/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import org.openvpms.component.business.domain.im.common.SequencedPeriodRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.relationship.RelationshipCollectionEditor;
import org.openvpms.web.component.im.relationship.RelationshipCollectionPropertyEditor;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.component.im.relationship.SequencedRelationshipCollectionHelper;
import org.openvpms.web.component.im.relationship.SequencedTable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.focus.FocusGroup;

public abstract class MultipleSequencedRelationshipCollectionEditor
extends RelationshipCollectionEditor {
    private final boolean sequenced;
    private List<RelationshipState> relationships;
    private SequencedTable<RelationshipState> table;

    public MultipleSequencedRelationshipCollectionEditor(RelationshipCollectionPropertyEditor editor, IMObject object, LayoutContext context) {
        super(editor, object, context);
        this.sequenced = SequencedRelationshipCollectionHelper.hasSequenceNode(editor.getArchetypeRange());
    }

    @Override
    public IMObject create() {
        SequencedPeriodRelationship relationship = (SequencedPeriodRelationship)super.create();
        if (this.sequenced && this.relationships != null && !this.relationships.isEmpty()) {
            RelationshipState state = this.relationships.get(this.relationships.size() - 1);
            SequencedPeriodRelationship last = (SequencedPeriodRelationship)state.getRelationship();
            int sequence = last.getSequence();
            relationship.setSequence(++sequence);
        }
        return relationship;
    }

    @Override
    protected ResultSet<RelationshipState> createResultSet() {
        ResultSet<RelationshipState> result;
        RelationshipCollectionPropertyEditor editor = this.getCollectionPropertyEditor();
        ArrayList<RelationshipState> relationships = new ArrayList<RelationshipState>(editor.getRelationships());
        if (this.sequenced) {
            SequencedRelationshipCollectionHelper.sortStates(relationships);
            SequencedRelationshipCollectionHelper.sequenceStates(relationships);
            result = new ListResultSet<RelationshipState>(relationships, 15);
            this.relationships = relationships;
        } else {
            result = super.createResultSet();
        }
        return result;
    }

    @Override
    protected void doLayout(Component container, LayoutContext context) {
        if (this.sequenced) {
            this.doSequenceLayout(container);
        } else {
            super.doLayout(container, context);
        }
    }

    protected void doSequenceLayout(Component container) {
        this.table = new SequencedTable<RelationshipState>(this.getTable()){

            @Override
            public List<RelationshipState> getObjects() {
                return MultipleSequencedRelationshipCollectionEditor.this.relationships;
            }

            @Override
            public void swap(RelationshipState object1, RelationshipState object2) {
                int index;
                IMObjectEditor editor1 = MultipleSequencedRelationshipCollectionEditor.this.getEditor((IMObject)object1.getRelationship());
                IMObjectEditor editor2 = MultipleSequencedRelationshipCollectionEditor.this.getEditor((IMObject)object2.getRelationship());
                Property property1 = editor1.getProperty("sequence");
                Property property2 = editor2.getProperty("sequence");
                int value1 = property1.getInt();
                int value2 = property2.getInt();
                property1.setValue(value2);
                property2.setValue(value1);
                MultipleSequencedRelationshipCollectionEditor.this.populateTable();
                List objects = MultipleSequencedRelationshipCollectionEditor.this.getTable().getTable().getObjects();
                if (!objects.contains(object1) && (index = MultipleSequencedRelationshipCollectionEditor.this.relationships.indexOf(object1)) != -1) {
                    int page = index / MultipleSequencedRelationshipCollectionEditor.this.getTable().getModel().getRowsPerPage();
                    MultipleSequencedRelationshipCollectionEditor.this.getTable().getNavigator().setPage(page);
                }
                MultipleSequencedRelationshipCollectionEditor.this.getTable().getTable().setSelected(object1);
                this.enableNavigation(true);
            }
        };
        FocusGroup focusGroup = this.getFocusGroup();
        if (!this.isCardinalityReadOnly()) {
            ButtonRow row = this.createControls(focusGroup);
            container.add((Component)row);
        }
        this.table.layout(container, focusGroup);
        this.populateTable();
        this.enableNavigation(true);
    }

    @Override
    protected void enableNavigation(boolean enable) {
        super.enableNavigation(enable);
        if (this.table != null) {
            this.table.enableNavigation(enable);
        }
    }
}

