/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.relationship.RelationshipCollectionTargetPropertyEditor;
import org.openvpms.web.component.im.relationship.SequencedRelationshipCollectionHelper;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.system.ServiceHelper;

public class EntityLinkCollectionTargetPropertyEditor
extends RelationshipCollectionTargetPropertyEditor<EntityLink> {
    private final boolean sequenced;

    public EntityLinkCollectionTargetPropertyEditor(CollectionProperty property, Entity parent, IMObjects objects) {
        super(property, (IMObject)parent, objects);
        this.sequenced = SequencedRelationshipCollectionHelper.hasSequenceNode(property.getArchetypeRange());
        if (this.sequenced) {
            this.sequence();
        }
    }

    @Override
    public List<IMObject> getObjects() {
        List<IMObject> result;
        if (this.sequenced) {
            result = new ArrayList<IMObject>();
            List entries = SequencedRelationshipCollectionHelper.sort(this.getTargets());
            for (Map.Entry entry : entries) {
                result.add(entry.getKey());
            }
        } else {
            result = super.getObjects();
        }
        return result;
    }

    @Override
    protected EntityLink addRelationship(IMObject source, IMObject target, String shortName) {
        EntityLink link = (EntityLink)IMObjectCreator.create(shortName);
        if (link != null) {
            link.setSource(source.getObjectReference());
            link.setTarget(target.getObjectReference());
            Entity entity = (Entity)source;
            entity.addEntityLink(link);
            if (this.sequenced) {
                this.sequence(link);
            }
        }
        return link;
    }

    @Override
    protected boolean removeRelationship(IMObject source, IMObject target, EntityLink relationship) {
        return this.getProperty().remove(relationship);
    }

    @Override
    protected void remove() {
        ServiceHelper.getArchetypeService().save(this.getParent());
        super.remove();
    }

    protected void sequence() {
        List entries = SequencedRelationshipCollectionHelper.sort(this.getTargets());
        ArrayList relationships = new ArrayList();
        for (Map.Entry entry : entries) {
            relationships.add(entry.getValue());
        }
        SequencedRelationshipCollectionHelper.sequence(relationships);
    }

    protected void sequence(EntityLink relationship) {
        int sequence = SequencedRelationshipCollectionHelper.getNextSequence(this.getTargets().values());
        relationship.setSequence(sequence);
    }
}

