/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import echopointng.TabbedPane;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SplitPane;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.im.query.BrowserState;
import org.openvpms.web.component.im.query.TabbedBrowserListener;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.factory.TabbedPaneFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.tabpane.ObjectTabPaneModel;

public class TabbedBrowser<T>
implements Browser<T> {
    private List<Browser<T>> browsers = new ArrayList<Browser<T>>();
    private Column tabContainer;
    private SplitPane container;
    private ObjectTabPaneModel<Browser<T>> model;
    private TabbedPane tab;
    private List<BrowserListener<T>> listeners = new ArrayList<BrowserListener<T>>();
    private TabbedBrowserListener listener;
    private int selected = -1;
    private FocusGroup focusGroup = new FocusGroup(this.getClass().getName());

    public TabbedBrowser() {
        this.tabContainer = ColumnFactory.create((String)"InsetY");
        this.container = SplitPaneFactory.create((int)5, (String)"TabbedBrowser", (Component[])new Component[0]);
        this.container.add((Component)this.tabContainer);
        this.model = new ObjectTabPaneModel((Component)this.tabContainer);
    }

    public int addBrowser(String displayName, Browser<T> browser) {
        this.browsers.add(browser);
        for (BrowserListener<T> listener : this.listeners) {
            browser.addBrowserListener(listener);
        }
        return this.addTab(displayName, browser);
    }

    @Override
    public Component getComponent() {
        if (this.tab == null) {
            this.tab = TabbedPaneFactory.create(this.model);
            if (this.model.size() > 0) {
                this.selected = 0;
                this.onBrowserSelected(this.selected);
            }
            this.tab.setSelectedIndex(this.selected);
            this.tab.addPropertyChangeListener(evt -> {
                int index = this.tab.getSelectedIndex();
                if (index != this.selected) {
                    this.selected = index;
                    try {
                        this.onBrowserSelected(this.selected);
                    }
                    catch (Throwable exception) {
                        ErrorHelper.show(exception);
                    }
                }
            });
            this.tabContainer.add((Component)this.tab);
            this.focusGroup.add((Component)this.tab);
        }
        return this.container;
    }

    @Override
    public T getSelected() {
        Browser<T> browser = this.getSelectedBrowser();
        return browser != null ? (T)browser.getSelected() : null;
    }

    @Override
    public boolean setSelected(T object) {
        boolean result = false;
        Browser<T> browser = this.getSelectedBrowser();
        if (browser != null) {
            result = browser.setSelected(object);
        }
        return result;
    }

    @Override
    public List<T> getObjects() {
        Browser<T> browser = this.getSelectedBrowser();
        return browser != null ? browser.getObjects() : Collections.emptyList();
    }

    @Override
    public void addBrowserListener(BrowserListener<T> listener) {
        this.listeners.add(listener);
        for (Browser<T> browser : this.browsers) {
            browser.addBrowserListener(listener);
        }
    }

    @Override
    public void removeBrowserListener(BrowserListener<T> listener) {
        this.listeners.remove(listener);
        for (Browser<T> browser : this.browsers) {
            browser.removeBrowserListener(listener);
        }
    }

    @Override
    public void query() {
        for (Browser<T> browser : this.browsers) {
            this.query(browser);
        }
    }

    public List<Browser<T>> getBrowsers() {
        return this.browsers;
    }

    public Browser<T> getSelectedBrowser() {
        return this.selected != -1 ? this.browsers.get(this.selected) : null;
    }

    public void setSelectedBrowser(int index) {
        this.selected = index;
        this.tab.setSelectedIndex(this.selected);
        this.onBrowserSelected(this.selected);
    }

    public int getSelectedBrowserIndex() {
        return this.selected;
    }

    public void setListener(TabbedBrowserListener listener) {
        this.listener = listener;
    }

    @Override
    public BrowserState getBrowserState() {
        return new Memento(this);
    }

    @Override
    public void setBrowserState(BrowserState state) {
        int selected;
        Memento memento;
        if (state instanceof Memento && (memento = (Memento)state).state != null && (selected = memento.selected) >= 0 && selected < this.browsers.size()) {
            Browser<T> browser = this.browsers.get(selected);
            if (memento.state.supports(browser)) {
                this.setSelectedBrowser(selected);
                browser.setBrowserState(memento.state);
            }
        }
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    @Override
    public void setFocusOnResults() {
        this.getSelectedBrowser().setFocusOnResults();
    }

    protected void onBrowserSelected(int selected) {
        List objects;
        Browser browser;
        if (this.container.getComponentCount() == 2) {
            this.container.remove(1);
        }
        if ((browser = (Browser)this.model.getObject(selected)) != null) {
            this.container.add(browser.getComponent());
        }
        if (this.listener != null) {
            this.listener.onBrowserChanged();
        }
        if (browser != null && browser.getSelected() == null && !(objects = browser.getObjects()).isEmpty()) {
            Object current = objects.get(0);
            browser.setSelected(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void query(Browser<T> browser) {
        boolean suppressEvents;
        boolean bl = suppressEvents = this.getSelectedBrowser() != browser;
        if (suppressEvents) {
            for (BrowserListener<T> l : this.listeners) {
                browser.removeBrowserListener(l);
            }
        }
        try {
            T selected = browser.getSelected();
            browser.query();
            browser.setSelected(selected);
        }
        finally {
            if (suppressEvents) {
                for (BrowserListener<T> l : this.listeners) {
                    browser.addBrowserListener(l);
                }
            }
        }
    }

    protected int addTab(String displayName, Browser<T> browser) {
        String text;
        int result = this.model.size();
        int shortcut = result + 1;
        if (shortcut <= 10) {
            if (shortcut == 10) {
                shortcut = 0;
            }
            text = "&" + shortcut + " " + displayName;
        } else {
            text = displayName;
        }
        this.model.addTab(browser, text, (Component)new Label());
        return result;
    }

    protected void notifyBrowsed(T object) {
        for (BrowserListener<T> listener : this.listeners) {
            listener.browsed(object);
        }
    }

    private static class Memento
    implements BrowserState {
        private final int selected;
        private final BrowserState state;

        public Memento(TabbedBrowser<?> browser) {
            this.selected = ((TabbedBrowser)browser).selected;
            Browser<?> selectedBrowser = browser.getSelectedBrowser();
            this.state = selectedBrowser != null ? selectedBrowser.getBrowserState() : null;
        }

        @Override
        public boolean supports(Browser<?> browser) {
            if (this.state != null && browser instanceof TabbedBrowser) {
                TabbedBrowser tabbed = (TabbedBrowser)browser;
                if (this.selected >= 0 && this.selected < tabbed.browsers.size()) {
                    Browser tab = (Browser)tabbed.browsers.get(this.selected);
                    return this.state.supports(tab);
                }
            }
            return false;
        }

        @Override
        public boolean supports(String[] shortNames, Class<?> type) {
            return this.state != null && this.state.supports(shortNames, type);
        }

        @Override
        public boolean isEmpty() {
            return this.state == null || this.state.isEmpty();
        }
    }
}

