/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.query.DefaultQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryException;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryFactory {
    private static ArchetypeHandlers<Query<?>> queries;
    private static final Logger log;

    private QueryFactory() {
    }

    public static <T extends IMObject> Query<T> create(String shortName, Context context) {
        return QueryFactory.create(new String[]{shortName}, context, IMObject.class);
    }

    public static <T> Query<T> create(String shortName, Context context, Class<T> type) {
        return QueryFactory.create(new String[]{shortName}, context, type);
    }

    public static <T extends IMObject> Query<T> create(String[] shortNames, Context context) {
        return QueryFactory.create(shortNames, context, IMObject.class);
    }

    public static <T> Query<T> create(String[] shortNames, Context context, Class<T> type) {
        return QueryFactory.create(shortNames, true, context, type);
    }

    public static <T> Query<T> create(String[] shortNames, boolean exact, Context context, Class<T> type) {
        shortNames = DescriptorHelper.getShortNames((String[])shortNames, (ArchetypeService)ServiceHelper.getArchetypeService());
        ArchetypeHandler handler = QueryFactory.getQueries().getHandler(shortNames, exact);
        Query<T> query = handler == null ? QueryFactory.createDefaultQuery(shortNames, type) : QueryFactory.create(handler, shortNames, context, type);
        if (query == null) {
            throw new QueryException(QueryException.ErrorCode.NoQuery, StringUtils.join((Object[])shortNames, (String)", "), type.getName());
        }
        return query;
    }

    public static <T> void initialise(Query<T> query) {
        Class<?> type = query.getClass();
        ArchetypeHandlers<Query<?>> handlers = QueryFactory.getQueries();
        ArchetypeHandler handler = handlers.getHandler(type);
        if (handler != null) {
            QueryFactory.initialise(query, handler);
        } else {
            handler = handlers.getHandler(query.getShortNames());
            if (handler != null && handler.getType().isAssignableFrom(type)) {
                QueryFactory.initialise(query, handler);
            }
        }
    }

    protected static void initialise(Query<?> query, ArchetypeHandler<Query<?>> handler) {
        try {
            handler.initialise(query);
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
        }
    }

    private static <T> Query<T> create(ArchetypeHandler<Query<?>> handler, String[] shortNames, Context context, Class<T> type) {
        Query result = null;
        try {
            try {
                Object[] args = new Object[]{shortNames, context};
                result = (Query)handler.create(args);
            }
            catch (NoSuchMethodException exception) {
                try {
                    Object[] args = new Object[]{shortNames};
                    result = (Query)handler.create(args);
                }
                catch (NoSuchMethodException nested) {
                    try {
                        Object[] args = new Object[]{context};
                        result = (Query)handler.create(args);
                    }
                    catch (NoSuchMethodException nested2) {
                        result = (Query)handler.create();
                    }
                }
            }
            if (!type.isAssignableFrom(result.getType())) {
                result = null;
            }
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage(), throwable);
        }
        return result;
    }

    private static <T> Query<T> createDefaultQuery(String[] shortNames, Class<?> type) {
        if (IMObject.class.isAssignableFrom(type)) {
            return new DefaultQuery(shortNames, type);
        }
        return null;
    }

    private static synchronized ArchetypeHandlers<Query<?>> getQueries() {
        if (queries == null) {
            Class<Query> type = Query.class;
            queries = new ArchetypeHandlers("QueryFactory.properties", "DefaultQueryFactory.properties", type, "query.", (ArchetypeService)ArchetypeServiceHelper.getArchetypeService());
        }
        return queries;
    }

    static {
        log = LoggerFactory.getLogger(QueryFactory.class);
    }
}

