/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.IMObjectSelections;
import org.openvpms.web.component.im.query.IMObjectTableBrowser;
import org.openvpms.web.component.im.query.MultiSelectBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.table.DelegatingIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.table.TableHelper;

public class MultiSelectTableBrowser<T extends IMObject>
extends IMObjectTableBrowser<T>
implements MultiSelectBrowser<T> {
    private final SelectionTracker<T> tracker;
    private final MultiSelectTableModel model;

    public MultiSelectTableBrowser(Query<T> query, LayoutContext context) {
        this(query, new IMObjectSelections(), context);
    }

    public MultiSelectTableBrowser(Query<T> query, IMTableModel<T> model, LayoutContext context) {
        this(query, model, new IMObjectSelections(), context);
    }

    public MultiSelectTableBrowser(Query<T> query, SelectionTracker<T> tracker, LayoutContext context) {
        super(query, context);
        this.model = null;
        this.tracker = tracker;
    }

    public MultiSelectTableBrowser(Query<T> query, IMTableModel<T> model, SelectionTracker<T> tracker, LayoutContext context) {
        super(query, context);
        this.model = new MultiSelectTableModel(model);
        this.tracker = tracker;
    }

    @Override
    public Collection<T> getSelections() {
        return this.tracker.getSelected();
    }

    public void deselect(T object) {
        MultiSelectTableModel model = (MultiSelectTableModel)this.getTableModel();
        if (model != null) {
            model.deselect(object);
        }
    }

    @Override
    public void clearSelections() {
        MultiSelectTableModel model = (MultiSelectTableModel)this.getTableModel();
        if (model != null) {
            model.clearSelected();
        }
    }

    protected SelectionTracker<T> getSelectionTracker() {
        return this.tracker;
    }

    protected MultiSelectTableModel createTableModel(LayoutContext context) {
        MultiSelectTableModel result = this.model != null ? this.model : new MultiSelectTableModel(this.createChildTableModel(context));
        return result;
    }

    protected IMTableModel<T> createChildTableModel(LayoutContext context) {
        return super.createTableModel(context);
    }

    @Override
    protected void notifySelected(T selected) {
        if (this.tracker.canSelect(selected)) {
            if (this.selectObjectOnRowClick()) {
                ((MultiSelectTableModel)this.getTableModel()).setSelected(selected);
            }
            super.notifySelected(selected);
        } else {
            this.notifySelectionDisabled(selected);
        }
    }

    protected void notifySelectionDisabled(T object) {
    }

    protected boolean selectObjectOnRowClick() {
        return true;
    }

    protected void notifyToggled(T selected) {
        super.notifyBrowsed(selected);
    }

    protected nextapp.echo2.app.CheckBox getCheckBox(T object) {
        CheckBox box;
        if (this.tracker.canSelect(object)) {
            box = CheckBoxFactory.create((boolean)this.tracker.isSelected(object));
            box.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener((IMObject)object, (nextapp.echo2.app.CheckBox)box){
                final /* synthetic */ IMObject val$object;
                final /* synthetic */ nextapp.echo2.app.CheckBox val$box;
                {
                    this.val$object = iMObject;
                    this.val$box = checkBox;
                }

                public void onAction(ActionEvent event) {
                    MultiSelectTableBrowser.this.tracker.setSelected(this.val$object, this.val$box.isSelected());
                    MultiSelectTableBrowser.this.notifyToggled(this.val$object);
                }
            });
        } else {
            box = CheckBoxFactory.create();
            box.setEnabled(false);
        }
        return box;
    }

    protected class MultiSelectTableModel
    extends DelegatingIMTableModel<T, T> {
        private final TableColumn selectionColumn;
        private List<nextapp.echo2.app.CheckBox> selections;

        public MultiSelectTableModel(IMTableModel<T> model) {
            super(model);
            this.selections = new ArrayList<nextapp.echo2.app.CheckBox>();
            TableColumnModel columns = model.getColumnModel();
            this.selectionColumn = new TableColumn(TableHelper.getNextModelIndex((TableColumnModel)columns));
            columns.addColumn(this.selectionColumn);
            columns.moveColumn(TableHelper.getColumnOffset((TableColumnModel)columns, (int)this.selectionColumn.getModelIndex()), 0);
        }

        public TableColumn getSelectionColumn() {
            return this.selectionColumn;
        }

        @Override
        public void setObjects(List<T> objects) {
            super.setObjects(objects);
            this.selections = new ArrayList<nextapp.echo2.app.CheckBox>();
            for (IMObject object : objects) {
                nextapp.echo2.app.CheckBox box = MultiSelectTableBrowser.this.getCheckBox(object);
                this.selections.add(box);
            }
        }

        public List<T> getSelected() {
            ArrayList result = new ArrayList();
            for (int i = 0; i < this.selections.size(); ++i) {
                nextapp.echo2.app.CheckBox check = this.selections.get(i);
                if (!check.isSelected()) continue;
                result.add(this.getObjects().get(i));
            }
            return result;
        }

        public void clearSelected() {
            for (nextapp.echo2.app.CheckBox check : this.selections) {
                check.setSelected(false);
            }
            MultiSelectTableBrowser.this.tracker.clear();
        }

        @Override
        public Object getValueAt(int column, int row) {
            return column == this.selectionColumn.getModelIndex() ? this.selections.get(row) : super.getValueAt(column, row);
        }

        public void setSelected(T object) {
            int index = this.getObjects().indexOf(object);
            if (index != -1) {
                nextapp.echo2.app.CheckBox checkBox = this.selections.get(index);
                checkBox.setSelected(true);
                MultiSelectTableBrowser.this.tracker.setSelected(object, true);
            }
        }

        public void deselect(T object) {
            int index = this.getObjects().indexOf(object);
            if (index != -1) {
                nextapp.echo2.app.CheckBox checkBox = this.selections.get(index);
                checkBox.setSelected(false);
                MultiSelectTableBrowser.this.tracker.setSelected(object, false);
            }
        }
    }

    public static interface SelectionTracker<T> {
        public boolean isSelected(T var1);

        public void setSelected(T var1, boolean var2);

        public Collection<T> getSelected();

        public boolean canSelect(T var1);

        public void clear();
    }
}

