/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.Date;
import java.util.List;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractActResultSet;
import org.openvpms.web.component.im.query.DefaultQueryExecutor;
import org.openvpms.web.component.im.query.ParticipantConstraint;

public class LocationActResultSet<T extends Act>
extends AbstractActResultSet<T> {
    private final Party location;
    private final List<Party> locations;

    public LocationActResultSet(ShortNameConstraint archetypes, ParticipantConstraint[] participants, Party location, List<Party> locations, Date from, Date to, String[] statuses, boolean exclude, int pageSize, SortConstraint[] sort) {
        this(archetypes, null, participants, location, locations, from, to, statuses, exclude, pageSize, sort);
    }

    public LocationActResultSet(ShortNameConstraint archetypes, String value, ParticipantConstraint[] participants, Party location, List<Party> locations, Date from, Date to, String[] statuses, boolean exclude, int pageSize, SortConstraint[] sort) {
        super(archetypes, value, participants, from, to, statuses, exclude, null, pageSize, sort, new DefaultQueryExecutor());
        archetypes.setAlias("act");
        this.location = location;
        this.locations = locations;
    }

    @Override
    protected ArchetypeQuery createQuery() {
        ArchetypeQuery query = super.createQuery();
        if (this.location != null || this.locations.size() == 1) {
            Party l = this.location != null ? this.location : this.locations.get(0);
            query.add((IConstraint)new ParticipantConstraint("location", "participation.location", (Entity)l));
        } else if (!this.locations.isEmpty()) {
            this.setDistinct(true);
            OrConstraint or = new OrConstraint();
            or.add(this.getLocations());
            or.add((IConstraint)Constraints.notExists((ArchetypeQuery)Constraints.subQuery((String[])this.getArchetypes().getShortNames(), (String)"i2").add((IConstraint)Constraints.join((String)"location").add((IConstraint)Constraints.join((String)"entity").add((IConstraint)Constraints.idEq((String)"act", (String)"i2"))))));
            query.add((IConstraint)or);
        }
        return query;
    }

    private IConstraint getLocations() {
        JoinConstraint result = Constraints.join((String)"location");
        OrConstraint or = new OrConstraint();
        result.add((IConstraint)or);
        for (Party l : this.locations) {
            or.add((IConstraint)Constraints.eq((String)"entity", (Reference)l.getObjectReference()));
        }
        return result;
    }
}

