/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.IMObjectListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetAdapter;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.component.im.util.VirtualNodeSortConstraint;

public class LocalSortResultSet<T extends IMObject>
extends ResultSetAdapter<T, T> {
    private ResultSet<T> original;
    private IMObjectListResultSet<T> local;

    public LocalSortResultSet(ResultSet<T> set) {
        super(set);
        this.original = set;
    }

    @Override
    public void sort(SortConstraint[] sort) {
        ResultSet<T> set;
        if (!this.sortLocally(sort)) {
            set = this.original;
            this.local = null;
        } else {
            if (this.local == null) {
                ArrayList objects = new ArrayList();
                this.original.reset();
                CollectionUtils.addAll(objects, new ResultSetIterator<T>(this.original));
                this.local = new IMObjectListResultSet(objects, this.getPageSize());
            }
            set = this.local;
        }
        set.sort(sort);
        this.setResultSet(set);
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.original.setDistinct(distinct);
    }

    @Override
    public boolean isDistinct() {
        return this.original.isDistinct();
    }

    @Override
    public void setNodes(String[] nodes) {
        this.original.setNodes(nodes);
    }

    @Override
    public ResultSet<T> clone() throws CloneNotSupportedException {
        LocalSortResultSet result = (LocalSortResultSet)super.clone();
        if (this.original != this.getResultSet()) {
            result.original = this.original.clone();
        }
        return result;
    }

    @Override
    protected IPage<T> convert(IPage<T> page) {
        return page;
    }

    private boolean sortLocally(SortConstraint[] sort) {
        if (sort != null) {
            for (SortConstraint s : sort) {
                if (!(s instanceof VirtualNodeSortConstraint)) continue;
                return true;
            }
        }
        return false;
    }
}

