/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.Iterator;
import org.openvpms.component.business.dao.im.Page;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractCachingResultSet;

public class IterableBackedResultSet<T>
extends AbstractCachingResultSet<T> {
    private final Iterable<T> iterable;
    private Iterator<T> iterator;
    private int lastIndex;

    public IterableBackedResultSet(Iterable<T> iterable, int pageSize) {
        super(pageSize);
        this.iterable = iterable;
        this.iterator = iterable.iterator();
    }

    @Override
    public void reset() {
        super.reset();
        this.lastIndex = 0;
        this.iterator = this.iterable.iterator();
    }

    @Override
    public void sort(SortConstraint[] sort) {
        this.reset();
    }

    @Override
    public boolean isSortedAscending() {
        return true;
    }

    @Override
    public SortConstraint[] getSortConstraints() {
        return new SortConstraint[0];
    }

    @Override
    public void setDistinct(boolean distinct) {
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    protected IPage<T> query(int firstResult, int maxResults) {
        if (firstResult < this.lastIndex) {
            this.reset();
        }
        while (this.lastIndex < firstResult && this.iterator.hasNext()) {
            this.iterator.next();
            ++this.lastIndex;
        }
        ArrayList<T> matches = new ArrayList<T>();
        for (int i = 0; i < maxResults && this.iterator.hasNext(); ++i) {
            matches.add(this.iterator.next());
        }
        return new Page(matches, firstResult, this.getPageSize(), -1);
    }

    @Override
    protected int countResults() {
        int count = 0;
        for (T match : this.iterable) {
            ++count;
        }
        return count;
    }
}

