/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserState;
import org.openvpms.web.system.ServiceHelper;

public class BrowserStates {
    private final List<BrowserState> states = new ArrayList<BrowserState>();

    public synchronized void add(Browser browser) {
        BrowserState state = browser.getBrowserState();
        if (state != null) {
            boolean found = false;
            ListIterator<BrowserState> iter = this.states.listIterator();
            while (iter.hasNext()) {
                BrowserState existing = iter.next();
                if (!existing.supports(browser)) continue;
                iter.set(state);
                found = true;
                break;
            }
            if (!found) {
                this.states.add(state);
            }
        }
    }

    public synchronized boolean setBrowserState(Browser browser) {
        boolean result = false;
        for (BrowserState state : this.states) {
            if (!state.supports(browser)) continue;
            browser.setBrowserState(state);
            result = true;
            break;
        }
        return result;
    }

    public synchronized boolean exists(Class type, String[] shortNames) {
        for (BrowserState state : this.states) {
            if (!state.supports(shortNames, type)) continue;
            return true;
        }
        return false;
    }

    public static BrowserStates getInstance() {
        return (BrowserStates)ServiceHelper.getContext().getBean("browserStates");
    }
}

