/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.NoSuchElementException;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.web.component.im.query.ResultSet;

public abstract class AbstractResultSet<T>
implements ResultSet<T> {
    private final int pageSize;
    private IPage<T> currentPage;
    private int cursor;
    private String[] nodes;

    public AbstractResultSet(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public void reset() {
        this.currentPage = null;
        this.cursor = 0;
    }

    @Override
    public boolean hasPage(int page) {
        return this.get(page) != null;
    }

    @Override
    public IPage<T> getPage(int page) {
        int row = page * this.pageSize;
        if (this.currentPage == null || this.currentPage.getFirstResult() != row) {
            this.currentPage = this.get(page);
            if (this.currentPage != null && this.currentPage.getResults().isEmpty()) {
                this.currentPage = null;
            }
        }
        this.cursor = page;
        return this.currentPage;
    }

    @Override
    public int getPages() {
        return this.getPages(true);
    }

    @Override
    public int getEstimatedPages() {
        int pages;
        if (this.pageSize == -1) {
            return 1;
        }
        int results = this.getEstimatedResults();
        if (results != -1) {
            pages = results / this.pageSize;
            if (results % this.pageSize > 0) {
                ++pages;
            }
        } else {
            pages = -1;
        }
        return pages;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setNodes(String[] nodes) {
        this.nodes = nodes;
    }

    public String[] getNodes() {
        return this.nodes;
    }

    @Override
    public boolean hasNext() {
        return this.get(this.cursor) != null;
    }

    @Override
    public boolean hasPrevious() {
        return this.cursor != 0;
    }

    @Override
    public IPage<T> next() {
        IPage<T> page = this.get(this.cursor);
        if (page == null) {
            throw new NoSuchElementException();
        }
        this.currentPage = page;
        ++this.cursor;
        return page;
    }

    @Override
    public IPage<T> previous() {
        IPage<T> page = this.get(this.cursor - 1);
        if (page == null) {
            throw new NoSuchElementException();
        }
        this.currentPage = page;
        --this.cursor;
        return page;
    }

    @Override
    public int nextIndex() {
        return this.cursor;
    }

    @Override
    public int previousIndex() {
        return this.cursor - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(IPage<T> object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(IPage<T> object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndex() {
        int page = -1;
        if (this.currentPage != null) {
            page = this.pageSize != -1 ? this.currentPage.getFirstResult() / this.pageSize : 0;
        }
        return page;
    }

    @Override
    public ResultSet<T> clone() throws CloneNotSupportedException {
        return (ResultSet)super.clone();
    }

    protected int getPages(boolean force) {
        int pages;
        int results;
        if (this.pageSize == -1) {
            return 1;
        }
        int n = results = force ? this.getResults() : this.getEstimatedResults();
        if (results != -1) {
            pages = results / this.pageSize;
            if (results % this.pageSize > 0) {
                ++pages;
            }
        } else {
            pages = 1;
        }
        return pages;
    }

    protected abstract IPage<T> get(int var1);

    protected IPage<T> getPage() {
        return this.currentPage;
    }

    protected int getFirstResult(int page) {
        return this.pageSize == -1 ? 0 : page * this.pageSize;
    }
}

