/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractArchetypeServiceResultSet;
import org.openvpms.web.component.im.query.QueryExecutor;

public abstract class AbstractIMObjectResultSet<T>
extends AbstractArchetypeServiceResultSet<T> {
    protected static final String ID = "id";
    protected static final String NAME = "name";
    private final ShortNameConstraint archetypes;
    private String value;
    private List<String> nodes = Collections.emptyList();

    public AbstractIMObjectResultSet(ShortNameConstraint archetypes, String value, IConstraint constraints, SortConstraint[] sort, int rows, boolean distinct, QueryExecutor<T> executor) {
        super(constraints, rows, sort, executor);
        this.archetypes = archetypes;
        this.setSearch(value, ID, NAME);
        this.setDistinct(distinct);
    }

    public void setSearch(String value, String ... nodes) {
        this.value = value;
        this.nodes = new ArrayList<String>();
        List<ArchetypeDescriptor> descriptors = this.getArchetypes(this.archetypes);
        for (String node : nodes) {
            if (!this.hasNode(descriptors, node)) continue;
            this.nodes.add(node);
        }
        this.reset();
    }

    public List<String> getSearch() {
        return this.nodes;
    }

    public String getValue() {
        return this.value;
    }

    protected ShortNameConstraint getArchetypes() {
        return this.archetypes;
    }

    @Override
    protected ArchetypeQuery createQuery() {
        ArchetypeQuery query = this.createQuery(this.getArchetypes());
        this.addValueConstraints(query);
        return query;
    }

    protected ArchetypeQuery createQuery(ShortNameConstraint archetypes) {
        return new ArchetypeQuery((BaseArchetypeConstraint)archetypes);
    }

    protected void addValueConstraints(ArchetypeQuery query) {
        if (!StringUtils.isEmpty((CharSequence)this.value) && !this.nodes.isEmpty()) {
            List<IConstraint> constraints = this.createValueConstraints(this.value, this.nodes);
            if (constraints.size() > 1) {
                OrConstraint or = new OrConstraint();
                for (IConstraint constraint : constraints) {
                    or.add(constraint);
                }
                query.add((IConstraint)or);
            } else if (constraints.size() == 1) {
                query.add(constraints.get(0));
            }
        }
    }

    protected List<IConstraint> createValueConstraints(String value, List<String> nodes) {
        String alias = this.getArchetypes().getAlias();
        ArrayList<IConstraint> constraints = new ArrayList<IConstraint>();
        for (String node : nodes) {
            if (ID.equals(node)) {
                Long id = this.getId(value);
                if (id == null) continue;
                String name = alias != null ? alias + "." + ID : ID;
                constraints.add((IConstraint)Constraints.eq((String)name, (Object)id));
                continue;
            }
            String name = alias != null ? alias + "." + node : node;
            constraints.add((IConstraint)Constraints.eq((String)name, (Object)value));
        }
        return constraints;
    }

    @Override
    protected void addSortConstraints(ArchetypeQuery query) {
        super.addSortConstraints(query);
        String alias = this.getArchetypes().getAlias();
        query.add((IConstraint)new NodeSortConstraint(alias, ID));
    }

    @Override
    protected void addReferenceConstraint(ArchetypeQuery query, Reference reference) {
        query.add((IConstraint)new ObjectRefConstraint(this.archetypes.getAlias(), reference));
    }

    protected List<ArchetypeDescriptor> getArchetypes(ShortNameConstraint archetypes) {
        IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
        String[] shortNames = DescriptorHelper.getShortNames((String[])archetypes.getShortNames(), (ArchetypeService)service);
        ArrayList<ArchetypeDescriptor> result = new ArrayList<ArchetypeDescriptor>(shortNames.length);
        for (String shortName : shortNames) {
            ArchetypeDescriptor archetype = service.getArchetypeDescriptor(shortName);
            if (archetype == null) continue;
            result.add(archetype);
        }
        return result;
    }

    protected boolean hasNode(List<ArchetypeDescriptor> archetypes, String node) {
        for (ArchetypeDescriptor archetype : archetypes) {
            NodeDescriptor descriptor = archetype.getNodeDescriptor(node);
            if (descriptor != null) continue;
            return false;
        }
        return true;
    }
}

