/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.Date;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.AndConstraint;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.ArchetypeQueryException;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.component.system.common.query.RelationalOp;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractIMObjectResultSet;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.QueryExecutor;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractActResultSet<T>
extends AbstractIMObjectResultSet<T> {
    private final IConstraint statuses;
    private final IConstraint times;
    private final ParticipantConstraint[] participants;

    public AbstractActResultSet(ShortNameConstraint archetypes, int pageSize, SortConstraint[] sort, QueryExecutor<T> executor) {
        this(archetypes, null, null, null, null, pageSize, sort, executor);
    }

    public AbstractActResultSet(ShortNameConstraint archetypes, ParticipantConstraint participant, Date from, Date to, String[] statuses, int pageSize, SortConstraint[] sort, QueryExecutor<T> executor) {
        this(archetypes, null, participant, from, to, statuses, pageSize, sort, executor);
    }

    public AbstractActResultSet(ShortNameConstraint archetypes, String value, ParticipantConstraint participant, Date from, Date to, String[] statuses, int pageSize, SortConstraint[] sort, QueryExecutor<T> executor) {
        this(archetypes, value, participant, from, to, statuses, false, null, pageSize, sort, executor);
    }

    public AbstractActResultSet(ShortNameConstraint archetypes, ParticipantConstraint participant, Date from, Date to, String[] statuses, boolean exclude, IConstraint constraints, int pageSize, SortConstraint[] sort, QueryExecutor<T> executor) {
        this(archetypes, null, participant, from, to, statuses, exclude, constraints, pageSize, sort, executor);
    }

    public AbstractActResultSet(ShortNameConstraint archetypes, String value, ParticipantConstraint participant, Date from, Date to, String[] statuses, boolean exclude, IConstraint constraints, int pageSize, SortConstraint[] sort, QueryExecutor<T> executor) {
        ParticipantConstraint[] participantConstraintArray;
        if (participant != null) {
            ParticipantConstraint[] participantConstraintArray2 = new ParticipantConstraint[1];
            participantConstraintArray = participantConstraintArray2;
            participantConstraintArray2[0] = participant;
        } else {
            participantConstraintArray = null;
        }
        this(archetypes, value, participantConstraintArray, AbstractActResultSet.createDateConstraint(from, to), statuses, exclude, constraints, pageSize, sort, executor);
    }

    public AbstractActResultSet(ShortNameConstraint archetypes, ParticipantConstraint[] participants, Date from, Date to, String[] statuses, boolean exclude, IConstraint constraints, int pageSize, SortConstraint[] sort, QueryExecutor<T> executor) {
        this(archetypes, null, participants, from, to, statuses, exclude, constraints, pageSize, sort, executor);
    }

    public AbstractActResultSet(ShortNameConstraint archetypes, String value, ParticipantConstraint[] participants, Date from, Date to, String[] statuses, boolean exclude, IConstraint constraints, int pageSize, SortConstraint[] sort, QueryExecutor<T> executor) {
        this(archetypes, value, participants, AbstractActResultSet.createDateConstraint(from, to), statuses, exclude, constraints, pageSize, sort, executor);
    }

    public AbstractActResultSet(ShortNameConstraint archetypes, String value, ParticipantConstraint[] participants, IConstraint times, String[] statuses, boolean exclude, IConstraint constraints, int pageSize, SortConstraint[] sort, QueryExecutor<T> executor) {
        super(archetypes, value, constraints, sort, pageSize, false, executor);
        this.participants = participants;
        this.statuses = this.createStatusConstraint(statuses, exclude);
        this.times = times;
        this.setSearch(value, "id");
    }

    @Override
    protected ArchetypeQuery createQuery(ShortNameConstraint archetypes) {
        ArchetypeQuery query = super.createQuery(archetypes);
        if (this.statuses != null) {
            query.add(this.statuses);
        }
        if (this.times != null) {
            query.add(this.times);
        }
        if (this.participants != null) {
            String[] shortNames = DescriptorHelper.getShortNames((String[])archetypes.getShortNames(), (boolean)archetypes.isPrimaryOnly(), (ArchetypeService)ServiceHelper.getArchetypeService());
            try {
                for (ParticipantConstraint participant : this.participants) {
                    ParticipantConstraint p = (ParticipantConstraint)((Object)participant.clone());
                    if (shortNames.length > 1) {
                        OrConstraint or = new OrConstraint();
                        for (String shortName : shortNames) {
                            or.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)shortName));
                        }
                        p.add((IConstraint)or);
                    } else if (shortNames.length == 1) {
                        p.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)shortNames[0]));
                    }
                    query.add((IConstraint)p);
                }
            }
            catch (CloneNotSupportedException exception) {
                throw new ArchetypeQueryException(ArchetypeQueryException.ErrorCode.CloneNotSupported, (Throwable)exception);
            }
        }
        return query;
    }

    @Override
    protected ArchetypeQuery createQuery(int firstResult, int maxResults) {
        ArchetypeQuery query = this.createQuery();
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        query.setDistinct(this.isDistinct());
        query.setCountResults(false);
        IConstraint constraints = this.getConstraints();
        if (constraints != null) {
            query.add(constraints);
        }
        if (this.getReferenceConstraint() != null) {
            this.addReferenceConstraint(query, this.getReferenceConstraint());
        }
        ShortNameConstraint archetypes = this.getArchetypes();
        for (SortConstraint sort : this.getSortConstraints()) {
            if (sort instanceof NodeSortConstraint) {
                NodeSortConstraint node = (NodeSortConstraint)sort;
                NodeDescriptor descriptor = QueryHelper.getDescriptor(archetypes, node.getNodeName());
                if (descriptor != null && QueryHelper.isParticipationNode(descriptor)) {
                    ShortNameConstraint shortNames = (ShortNameConstraint)query.getArchetypeConstraint();
                    QueryHelper.addSortOnParticipation(shortNames, query, descriptor, node.isAscending());
                    continue;
                }
                query.add((IConstraint)sort);
                continue;
            }
            query.add((IConstraint)sort);
        }
        return query;
    }

    @Override
    protected void addReferenceConstraint(ArchetypeQuery query, Reference reference) {
        query.add((IConstraint)new ObjectRefConstraint(this.getArchetypes().getAlias(), reference));
    }

    protected IConstraint createStatusConstraint(String[] statuses, boolean exclude) {
        return this.createStatusConstraint("status", statuses, exclude);
    }

    protected IConstraint createStatusConstraint(String node, String[] statuses, boolean exclude) {
        AndConstraint result = null;
        if (statuses != null && statuses.length > 1) {
            RelationalOp op;
            AndConstraint constraint;
            if (exclude) {
                constraint = new AndConstraint();
                op = RelationalOp.NE;
            } else {
                constraint = new OrConstraint();
                op = RelationalOp.EQ;
            }
            for (String status : statuses) {
                constraint.add((IConstraint)new NodeConstraint(node, op, new Object[]{status}));
            }
            result = constraint;
        } else if (statuses != null && statuses.length == 1) {
            RelationalOp op = RelationalOp.EQ;
            if (exclude) {
                op = RelationalOp.NE;
            }
            result = new NodeConstraint(node, op, new Object[]{statuses[0]});
        }
        return result;
    }

    private static IConstraint createDateConstraint(Date from, Date to) {
        return QueryHelper.createDateConstraint("startTime", from, to);
    }
}

