/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;

public class ProductTaskLayoutStrategy
extends AbstractLayoutStrategy {
    public ProductTaskLayoutStrategy() {
        super(ArchetypeNodes.all().exclude("startUnits"));
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        this.addComponent(this.createStart(object, properties, context));
        this.addComponent(this.createWorkList(object, properties, context));
        return super.apply(object, properties, parent, context);
    }

    private ComponentState createStart(IMObject object, PropertySet properties, LayoutContext context) {
        ComponentState result;
        Property start = properties.get("start");
        if (start.getInt() == 0) {
            result = new ComponentState((Component)LabelFactory.create((String)"product.task.startWhenInvoiced"), start);
        } else {
            Property startUnits = properties.get("startUnits");
            ComponentState pair = this.createComponentPair(start, startUnits, object, context);
            Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{pair.getComponent(), LabelFactory.create((String)"product.task.startAfterInvoicing")});
            result = new ComponentState((Component)row, start);
        }
        return result;
    }

    private ComponentState createWorkList(IMObject object, PropertySet properties, LayoutContext context) {
        Property worklist = properties.get("worklist");
        ComponentState result = worklist.getReference() == null ? new ComponentState((Component)LabelFactory.create((String)"product.task.useFollowUp"), worklist) : context.getComponentFactory().create(worklist, object);
        return result;
    }
}

