/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import org.openvpms.component.business.domain.im.common.EntityLink;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.edit.AbstractIMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.PreferredSupplierEditor;
import org.openvpms.web.component.im.product.ProductEditor;
import org.openvpms.web.component.im.query.EntityQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.relationship.EntityLinkEditor;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;

public class ProductStockLocationEditor
extends EntityLinkEditor {
    private final PreferredSupplierEditor supplier = new PreferredSupplierEditor(this, this.getProperty("supplier"), this.getLayoutContext());
    private ProductEditor productEditor;

    public ProductStockLocationEditor(EntityLink relationship, IMObject parent, LayoutContext context) {
        super((org.openvpms.component.model.entity.EntityLink)relationship, parent, context);
        this.addEditor(this.supplier);
        this.getArchetypeNodes().simple("supplier");
    }

    public void setProductEditor(ProductEditor editor) {
        this.productEditor = editor;
    }

    public ProductEditor getProductEditor() {
        return this.productEditor;
    }

    public Product getProduct() {
        IMObject parent = this.getParent();
        return parent instanceof Product ? (Product)parent : (Product)this.getObject(this.getSource().getReference());
    }

    public Party getStockLocation() {
        IMObject parent = this.getParent();
        return parent instanceof Party ? (Party)parent : (Party)this.getObject(this.getTarget().getReference());
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        IMObjectLayoutStrategy strategy = super.createLayoutStrategy();
        strategy.addComponent(new ComponentState(this.supplier));
        return strategy;
    }

    @Override
    protected IMObjectReferenceEditor<Entity> createTargetEditor(Property property, LayoutContext context) {
        return new AbstractIMObjectReferenceEditor<Entity>(property, this.getObject(), context){

            @Override
            protected boolean isValidReference(Reference reference) {
                Query query = this.createQuery(null);
                if (query instanceof EntityQuery) {
                    ((EntityQuery)query).setActiveOnly(false);
                }
                return query.selects(reference);
            }
        };
    }
}

