/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.math.BigDecimal;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class ProductPriceLayoutStrategy
extends AbstractLayoutStrategy {
    private final Property taxIncPrice;

    public ProductPriceLayoutStrategy() {
        this((Property)null);
    }

    public ProductPriceLayoutStrategy(Property taxIncPrice) {
        this.taxIncPrice = taxIncPrice;
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Property notes = properties.get("notes");
        if (notes != null) {
            this.addComponent(this.createMultiLineText(notes, 1, 2, new Extent(80, 128), context));
        }
        return super.apply(object, properties, parent, context);
    }

    @Override
    protected ArchetypeNodes getArchetypeNodes(IMObject object, LayoutContext context) {
        ArchetypeNodes nodes = ProductHelper.hasPricingGroups((ProductPrice)object) ? super.getArchetypeNodes(object, context) : (!context.isEdit() || !ProductHelper.pricingGroupsConfigured() ? new ArchetypeNodes().exclude("pricingGroups") : super.getArchetypeNodes(object, context));
        return nodes;
    }

    @Override
    protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        if (this.taxIncPrice != null) {
            ArchetypeNodes.insertAfter(properties, "price", this.taxIncPrice);
        } else if (parent instanceof Product) {
            BigDecimal price = this.getTaxIncPrice((ProductPrice)object, (Product)parent, context);
            SimpleProperty taxInc = new SimpleProperty("taxIncPrice", (Object)price, BigDecimal.class, Messages.get((String)"product.price.taxinc"));
            taxInc.setValue(price);
            ArchetypeNodes.insertAfter(properties, "price", taxInc);
        }
        super.doSimpleLayout(object, parent, properties, container, context);
    }

    private BigDecimal getTaxIncPrice(ProductPrice object, Product product, LayoutContext context) {
        BigDecimal price;
        BigDecimal result = price = object.getPrice();
        PracticeService service = ServiceHelper.getBean(PracticeService.class);
        Currency currency = service.getCurrency();
        Party practice = context.getContext().getPractice();
        if (price != null && currency != null && practice != null) {
            ProductPriceRules rules = ServiceHelper.getBean(ProductPriceRules.class);
            result = rules.getTaxIncPrice(price, product, practice, currency);
        }
        return result;
    }
}

