/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeList;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.archetype.ArchetypeRange;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategyFactory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductReferenceEditor;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.DelegatingProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.ReadOnlyProperty;
import org.openvpms.web.system.ServiceHelper;

public class ProductParticipationEditor
extends ParticipationEditor<Product> {
    private final Column container = new Column();
    private Party patient;
    private Party supplier;
    private ProductSupplier productSupplier;
    private Party location;
    private Party stockLocation;
    private boolean excludeTemplateOnlyProducts;
    private boolean useLocationProducts;
    private String[] shortNames;
    private boolean readOnly;

    public ProductParticipationEditor(Participation participation, Act parent, LayoutContext context) {
        super(participation, parent, context);
        Party practice;
        if (!TypeHelper.isA((IMObject)participation, (String[])new String[]{"participation.product", "participation.medication", "participation.stock"})) {
            throw new IllegalArgumentException("Invalid participation type:" + participation.getArchetype());
        }
        this.resetShortNames();
        if (TypeHelper.isA((IMObject)parent, (String[])new String[]{"act.customer*", "act.patient*"}) && (practice = context.getContext().getPractice()) != null) {
            this.useLocationProducts = ServiceHelper.getBean(PracticeRules.class).useLocationProducts(practice);
            if (this.useLocationProducts) {
                this.setLocations(context.getContext().getLocation());
            }
        }
    }

    @Override
    public Component getComponent() {
        if (this.container.getComponentCount() == 0) {
            this.container.add(super.getComponent());
        }
        return this.container;
    }

    public void setShortNames(String ... shortNames) {
        this.shortNames = shortNames;
    }

    public void resetShortNames() {
        this.shortNames = this.getEntityProperty().getArchetypeRange();
    }

    public void setPatient(Party patient) {
        this.patient = patient;
    }

    public Party getPatient() {
        return this.patient;
    }

    public void setSupplier(Party supplier) {
        this.supplier = supplier;
        this.productSupplier = null;
    }

    public Party getSupplier() {
        return this.supplier;
    }

    public void setLocations(Party location) {
        Party stockLocation = null;
        this.setLocation(location);
        if (location != null) {
            LocationRules bean = ServiceHelper.getBean(LocationRules.class);
            stockLocation = bean.getDefaultStockLocation(location);
        }
        this.setStockLocation(stockLocation);
    }

    public void setLocation(Party location) {
        this.location = location;
    }

    public Party getLocation() {
        return this.location;
    }

    public void setStockLocation(Party location) {
        this.stockLocation = location;
    }

    public Party getStockLocation() {
        return this.stockLocation;
    }

    public ProductSupplier getProductSupplier() {
        return this.productSupplier;
    }

    public void setProductSupplier(ProductSupplier relationship) {
        this.productSupplier = relationship;
    }

    public void setExcludeTemplateOnlyProducts(boolean exclude) {
        this.excludeTemplateOnlyProducts = exclude;
    }

    public boolean getExcludeTemplateOnlyProducts() {
        return this.excludeTemplateOnlyProducts;
    }

    public void setUseLocationProducts(boolean useLocationProducts) {
        this.useLocationProducts = useLocationProducts;
    }

    public boolean useLocationProducts() {
        return this.useLocationProducts;
    }

    public void setAllowCreate(boolean create) {
        this.getEntityEditor().setAllowCreate(create);
    }

    public boolean allowCreate() {
        return this.getEntityEditor().allowCreate();
    }

    public void setReadOnly(boolean readOnly) {
        boolean current = this.readOnly;
        this.readOnly = readOnly;
        if (readOnly != current) {
            this.onLayout();
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        IMObjectLayoutStrategy strategy;
        if (this.readOnly) {
            LayoutContext context = this.getLayoutContext();
            IMObjectLayoutStrategyFactory layoutStrategy = context.getLayoutStrategyFactory();
            IMObject object = this.getObject();
            strategy = layoutStrategy.create(object, this.getParent());
            ReadOnlyProperty property = new ReadOnlyProperty(this.getEntityProperty());
            ComponentState state = context.getComponentFactory().create((Property)property, object);
            strategy.addComponent(state);
        } else {
            strategy = super.createLayoutStrategy();
        }
        return strategy;
    }

    @Override
    protected void onLayout() {
        this.container.removeAll();
        super.onLayout();
        this.container.add(super.getComponent());
    }

    @Override
    protected IMObjectReferenceEditor<Product> createEntityEditor(Property property) {
        DelegatingProperty p = new DelegatingProperty(property){

            @Override
            public String[] getArchetypeRange() {
                return ProductParticipationEditor.this.shortNames;
            }

            @Override
            public ArchetypeRange getArchetypes() {
                return new ArchetypeList(ProductParticipationEditor.this.shortNames);
            }
        };
        return new ProductReferenceEditor(this, p, this.getLayoutContext());
    }
}

