/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.SelectFieldIMObjectCollectionEditor;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.list.IMObjectListModel;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.ReadOnlyComponentFactory;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.resource.i18n.Messages;

public class ProductDoseLayoutStrategy
extends AbstractLayoutStrategy {
    private static final ArchetypeNodes NODES = new ArchetypeNodes().exclude("maxWeight", "weightUnits");

    public ProductDoseLayoutStrategy() {
        super(NODES);
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        ComponentState species = context.isEdit() ? this.createSpeciesEditor(properties, object, context) : this.createSpeciesViewer(properties);
        this.addComponent(species);
        ComponentState minWeight = this.createComponent(properties.get("minWeight"), object, context);
        ComponentState maxWeight = this.createComponent(properties.get("maxWeight"), object, context);
        ComponentState weightUnits = this.createComponent(properties.get("weightUnits"), object, context);
        Label label = LabelFactory.create();
        label.setText("-");
        Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{minWeight.getComponent(), label, maxWeight.getComponent(), weightUnits.getComponent()});
        FocusGroup weight = new FocusGroup("weight", new Component[]{minWeight.getComponent(), maxWeight.getComponent(), weightUnits.getComponent()});
        String displayName = Messages.get((String)"product.weight");
        this.addComponent(new ComponentState((Component)row, minWeight.getProperty(), weight, displayName));
        return super.apply(object, properties, parent, context);
    }

    private ComponentState createSpeciesEditor(PropertySet properties, IMObject object, LayoutContext context) {
        CollectionProperty property = (CollectionProperty)properties.get("species");
        SelectFieldIMObjectCollectionEditor editor = new SelectFieldIMObjectCollectionEditor(property, object, context){

            @Override
            protected SelectField createSelectField(CollectionProperty property, List<IMObject> objects) {
                SelectField field = super.createSelectField(property, objects);
                if (property.getValues().isEmpty()) {
                    field.setSelectedIndex(0);
                }
                return field;
            }

            @Override
            protected IMObjectListModel createModel(CollectionProperty property, List<IMObject> objects) {
                return new IMObjectListModel((List<? extends IMObject>)objects, true, false);
            }
        };
        return new ComponentState(editor);
    }

    private ComponentState createSpeciesViewer(PropertySet properties) {
        String name;
        CollectionProperty property = (CollectionProperty)properties.get("species");
        List<?> values = property.getValues();
        if (!values.isEmpty()) {
            Lookup value = (Lookup)values.get(0);
            name = value.getName();
        } else {
            name = Messages.get((String)"list.all");
        }
        TextComponent text = ReadOnlyComponentFactory.getText(name, 20, 50, "default");
        return new ComponentState((Component)text, property);
    }
}

