/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.business.domain.im.common.PeriodRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.AbstractIMObjectTableModel;
import org.openvpms.web.component.im.util.VirtualNodeSortConstraint;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public class ProductBatchTableModel
extends AbstractIMObjectTableModel<Entity> {
    private final LayoutContext context;
    private static final int ID_INDEX = 0;
    private static final int BATCH_NUMBER_INDEX = 1;
    private static final int PRODUCT_INDEX = 2;
    private static final int EXPIRY_DATE_INDEX = 3;
    private static final int MANUFACTURER_INDEX = 4;

    public ProductBatchTableModel(LayoutContext context) {
        this(context, true, true);
    }

    public ProductBatchTableModel(LayoutContext context, boolean showId, boolean showProduct) {
        this.context = context;
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        if (showId) {
            model.addColumn(ProductBatchTableModel.createTableColumn(0, "table.imobject.id"));
        }
        model.addColumn(this.createTableColumn(1, "entity.productBatch", "name"));
        if (showProduct) {
            model.addColumn(this.createTableColumn(2, "entity.productBatch", "product"));
        }
        model.addColumn(this.createTableColumn(3, "entityLink.batchProduct", "activeEndTime"));
        model.addColumn(this.createTableColumn(4, "entity.productBatch", "manufacturer"));
        this.setTableColumnModel((TableColumnModel)model);
    }

    @Override
    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        SortConstraint[] result;
        switch (column) {
            case 0: {
                result = new SortConstraint[]{Constraints.sort((String)"id", (boolean)ascending)};
                break;
            }
            case 1: {
                result = new SortConstraint[]{Constraints.sort((String)"name", (boolean)ascending), Constraints.sort((String)"id", (boolean)true)};
                break;
            }
            case 2: {
                result = new SortConstraint[]{Constraints.sort((String)"product", (boolean)ascending), Constraints.sort((String)"name", (boolean)ascending), Constraints.sort((String)"id", (boolean)true)};
                break;
            }
            case 3: {
                result = new SortConstraint[]{new VirtualNodeSortConstraint("expiryDate", ascending), Constraints.sort((String)"name", (boolean)true), Constraints.sort((String)"id", (boolean)true)};
                break;
            }
            case 4: {
                result = new SortConstraint[]{Constraints.sort((String)"manufacturer", (boolean)ascending), Constraints.sort((String)"name", (boolean)ascending), Constraints.sort((String)"id", (boolean)true)};
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    @Override
    protected Object getValue(Entity object, TableColumn column, int row) {
        Object result = null;
        int index = column.getModelIndex();
        if (index == 0) {
            result = object.getId();
        } else if (index == 1) {
            result = object.getName();
        } else if (index == 2) {
            result = this.createReferenceViewer(object, "product");
        } else if (index == 3) {
            result = this.getExpiryDate(object);
        } else if (index == 4) {
            result = this.createReferenceViewer(object, "manufacturer");
        }
        return result;
    }

    private Component createReferenceViewer(Entity object, String node) {
        IMObjectBean bean = this.getBean((IMObject)object);
        ContextSwitchListener listener = this.context.isEdit() ? null : this.context.getContextSwitchListener();
        Reference ref = bean.getTargetRef(node);
        IMObjectReferenceViewer viewer = new IMObjectReferenceViewer(ref, listener, this.context.getContext());
        return viewer.getComponent();
    }

    private String getExpiryDate(Entity object) {
        IMObjectBean bean = this.getBean((IMObject)object);
        List values = bean.getValues("product", PeriodRelationship.class);
        Date expiry = null;
        if (!values.isEmpty()) {
            expiry = ((PeriodRelationship)values.get(0)).getActiveEndTime();
        }
        return expiry != null ? DateFormatter.formatDate(expiry, (boolean)false) : null;
    }

    private TableColumn createTableColumn(int index, String shortName, String node) {
        TableColumn column = new TableColumn(index);
        column.setHeaderValue((Object)this.getDisplayName(shortName, node));
        return column;
    }
}

