/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.Date;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectRefNodeConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.EntityResultSet;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.util.VirtualNodeSortConstraint;

public class ProductBatchResultSet
extends EntityResultSet<Entity> {
    private final Product product;
    private final String productName;
    private final Reference stockLocation;
    private final Date stockActive;
    private final Date from;
    private final Date to;
    private final Party manufacturer;
    private static final String EXPIRY_DATE = "activeEndTime";
    private static final SortConstraint[] EXPIRY_DATES = new SortConstraint[]{new VirtualNodeSortConstraint("expiryDate", true), Constraints.sort((String)"name", (boolean)true), Constraints.sort((String)"id", (boolean)true)};

    public ProductBatchResultSet(String value, Product product, Date from, Reference stockLocation, int rows) {
        this(Constraints.shortName((String)"entity.productBatch", (boolean)true), value, product, null, from, null, stockLocation, from, null, EXPIRY_DATES, rows);
    }

    public ProductBatchResultSet(ShortNameConstraint archetypes, String value, Product product, String productName, Date from, Date to, Reference stockLocation, Date stockActive, Party manufacturer, SortConstraint[] sort, int rows) {
        super(archetypes, value, false, null, sort, rows, false);
        this.product = product;
        this.productName = productName;
        this.from = DateRules.getDate((Date)from);
        this.to = DateRules.getPreviousDate((Date)to);
        this.stockLocation = stockLocation;
        this.stockActive = stockActive;
        this.manufacturer = manufacturer;
    }

    @Override
    protected ArchetypeQuery createQuery() {
        ArchetypeQuery query = super.createQuery();
        query.getArchetypeConstraint().setAlias("b");
        JoinConstraint productJoin = null;
        if (this.product != null || this.productName != null || this.from != null || this.to != null) {
            IConstraint expiryDateConstraint;
            productJoin = Constraints.join((String)"product", (String)"product");
            if (this.product != null) {
                productJoin.add((IConstraint)Constraints.eq((String)"target", (Object)this.product));
            }
            if (this.productName != null) {
                productJoin.add((IConstraint)Constraints.join((String)"target", (String)"t1").add((IConstraint)Constraints.eq((String)"name", (Object)this.productName)));
            }
            if ((expiryDateConstraint = QueryHelper.createDateConstraint(EXPIRY_DATE, this.from, this.to)) != null) {
                if (this.from != null && this.to == null) {
                    productJoin.add((IConstraint)Constraints.or((IConstraint[])new IConstraint[]{expiryDateConstraint, Constraints.isNull((String)EXPIRY_DATE)}));
                } else {
                    productJoin.add(expiryDateConstraint);
                }
            }
            query.add((IConstraint)productJoin);
        }
        if (this.stockLocation != null) {
            query.add((IConstraint)Constraints.leftJoin((String)"stockLocations", (String)"l"));
            ObjectRefNodeConstraint location = Constraints.eq((String)"l.target", (Reference)this.stockLocation);
            if (this.stockActive != null) {
                IConstraint active = QueryHelper.createDateRangeConstraint(this.stockActive, "l.activeStartTime", "l.activeEndTime");
                location = Constraints.and((IConstraint[])new IConstraint[]{location, active});
            }
            query.add((IConstraint)Constraints.or((IConstraint[])new IConstraint[]{location, Constraints.notExists((ArchetypeQuery)Constraints.subQuery((String)"entity.productBatch", (String)"b2").add((IConstraint)Constraints.join((String)"stockLocations", (String)"l2").add((IConstraint)Constraints.idEq((String)"b", (String)"b2"))))}));
        }
        if (this.manufacturer != null) {
            query.add((IConstraint)Constraints.join((String)"manufacturer").add((IConstraint)Constraints.eq((String)"target", (Object)this.manufacturer)));
        }
        for (SortConstraint sort : this.getSortConstraints()) {
            VirtualNodeSortConstraint node;
            if (sort instanceof VirtualNodeSortConstraint) {
                node = (VirtualNodeSortConstraint)sort;
                if (!"expiryDate".equals(node.getNodeName())) continue;
                if (productJoin == null) {
                    productJoin = Constraints.join((String)"product", (String)"product");
                    query.add((IConstraint)productJoin);
                }
                productJoin.add((IConstraint)Constraints.sort((String)"product", (String)EXPIRY_DATE, (boolean)node.isAscending()));
                continue;
            }
            if (sort instanceof NodeSortConstraint) {
                node = (NodeSortConstraint)sort;
                NodeDescriptor descriptor = QueryHelper.getDescriptor(this.getArchetypes(), node.getNodeName());
                if (descriptor != null && QueryHelper.isEntityLinkNode(descriptor)) {
                    ShortNameConstraint shortNames = (ShortNameConstraint)query.getArchetypeConstraint();
                    QueryHelper.addSortOnEntityLink(shortNames, query, descriptor, node.isAscending());
                    continue;
                }
                query.add((IConstraint)sort);
                continue;
            }
            query.add((IConstraint)sort);
        }
        return query;
    }

    @Override
    protected void addSortConstraints(ArchetypeQuery query) {
    }
}

