/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.web.component.im.list.LookupListCellRenderer;
import org.openvpms.web.component.im.list.LookupListModel;
import org.openvpms.web.component.im.lookup.ArchetypeLookupQuery;
import org.openvpms.web.echo.factory.ComponentFactory;

public class PricingGroupSelectField
extends SelectField {
    public PricingGroupSelectField(PricingGroup initialSelection, boolean all) {
        this(initialSelection != null ? initialSelection.getGroup() : null, all);
        if (initialSelection != null && initialSelection.isNone()) {
            this.setSelectedIndex(this.getModel().getNoneIndex());
        }
    }

    public PricingGroupSelectField(Lookup initialSelection, boolean all) {
        super(PricingGroupSelectField.createModel(all));
        ComponentFactory.setDefaultStyle((Component)this);
        this.setCellRenderer(LookupListCellRenderer.INSTANCE);
        if (initialSelection != null) {
            this.setSelectedItem(initialSelection.getCode());
        } else if (all) {
            this.setSelectedIndex(this.getModel().getAllIndex());
        } else if (this.getModel().size() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public boolean isAllSelected() {
        return this.getModel().isAll(this.getSelectedIndex());
    }

    public PricingGroup getSelected() {
        if (this.isAllSelected()) {
            return PricingGroup.ALL;
        }
        int index = this.getSelectedIndex();
        return index >= 0 ? new PricingGroup(this.getModel().getLookup(index), true) : null;
    }

    public LookupListModel getModel() {
        return (LookupListModel)super.getModel();
    }

    private static ListModel createModel(boolean all) {
        ArchetypeLookupQuery query = new ArchetypeLookupQuery("lookup.pricingGroup");
        return new LookupListModel(query, all, true);
    }
}

