/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.edit.AbstractIMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductStockLocationEditor;
import org.openvpms.web.component.im.query.EntityObjectSetQuery;
import org.openvpms.web.component.im.query.EntityObjectSetResultSet;
import org.openvpms.web.component.im.query.EntityQuery;
import org.openvpms.web.component.im.query.ListQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

class PreferredSupplierEditor
extends AbstractIMObjectReferenceEditor<Party> {
    private final ProductStockLocationEditor editor;

    public PreferredSupplierEditor(ProductStockLocationEditor editor, Property property, LayoutContext context) {
        super(property, editor.getParent(), new DefaultLayoutContext(context, context.getHelpContext().topic("product")));
        this.editor = editor;
    }

    @Override
    protected boolean isValidReference(Reference reference, Validator validator) {
        boolean result = this.isValidReference(reference);
        if (!result) {
            String product = this.editor.getProduct() != null ? this.editor.getProduct().getName() : "";
            String supplier = IMObjectHelper.getName(reference);
            String message = Messages.format((String)"product.supplier.invalid", (Object[])new Object[]{supplier, product, this.editor.getStockLocation().getName()});
            validator.add((Modifiable)this, new ValidatorError(message));
        }
        return result;
    }

    @Override
    protected boolean isValidReference(Reference reference) {
        Query<Party> query = this.createQuery(null, false);
        return query.selects(reference);
    }

    @Override
    protected Query<Party> createQuery(String name) {
        return this.createQuery(name, true);
    }

    private Query<Party> createQuery(String name, boolean allowAll) {
        Query<Party> result;
        final List<Long> suppliers = this.getSuppliers();
        String[] archetypeRange = this.getProperty().getArchetypeRange();
        if (!suppliers.isEmpty()) {
            EntityObjectSetQuery set = new EntityObjectSetQuery(archetypeRange){

                @Override
                protected ResultSet<ObjectSet> createResultSet(SortConstraint[] sort) {
                    return new EntityObjectSetResultSet(this.getArchetypeConstraint(), this.getValue(), this.isIdentitySearch(), sort, this.getMaxResults(), this.isDistinct()){

                        @Override
                        protected ArchetypeQuery createQuery() {
                            ArchetypeQuery query = super.createQuery();
                            Long[] values = suppliers.toArray(new Long[0]);
                            query.add((IConstraint)Constraints.in((String)"id", (Object[])values));
                            return query;
                        }
                    };
                }
            };
            result = new EntityQuery<Party>(set, this.getContext());
            result.setValue(name);
            result.setAuto(true);
        } else {
            result = allowAll ? super.createQuery(name) : new ListQuery<Party>(Collections.emptyList(), archetypeRange, Party.class);
        }
        return result;
    }

    private List<Long> getSuppliers() {
        ArrayList<Long> result = new ArrayList<Long>();
        List suppliers = null;
        if (this.editor.getProductEditor() != null) {
            suppliers = this.editor.getProductEditor().getSuppliers();
        } else {
            Product product = this.editor.getProduct();
            if (product != null) {
                IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)product);
                suppliers = bean.getTargetRefs("suppliers");
            }
        }
        if (suppliers != null) {
            for (Reference supplier : suppliers) {
                result.add(supplier.getId());
            }
        }
        return result;
    }
}

