/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.print;

import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.internal.document.CompressedDocumentImpl;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.practice.Location;
import org.openvpms.print.locator.DocumentPrinterServiceLocator;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.report.DocumentConverter;

public class PrinterContext {
    private final DocumentPrinterServiceLocator printerLocator;
    private final IArchetypeService service;
    private final DocumentConverter converter;
    private final DocumentHandlers handlers;
    private final DomainService domainService;

    public PrinterContext(DocumentPrinterServiceLocator printerLocator, IArchetypeService service, DocumentConverter converter, DocumentHandlers handlers, DomainService domainService) {
        this.printerLocator = printerLocator;
        this.service = service;
        this.converter = converter;
        this.handlers = handlers;
        this.domainService = domainService;
    }

    public DocumentPrinter getPrinter(PrinterReference reference) {
        return this.printerLocator.getPrinter(reference.getArchetype(), reference.getId());
    }

    public DocumentPrinter getDefaultPrinter(Party location) {
        IMObjectBean bean = this.service.getBean((IMObject)location);
        PrinterReference reference = PrinterReference.fromString((String)bean.getString("defaultPrinter"));
        DocumentPrinter result = reference != null ? this.getPrinter(reference) : this.printerLocator.getDefaultPrinter((Location)this.domainService.create((IMObject)location, Location.class));
        return result;
    }

    public DocumentPrinter getDefaultPrinter() {
        return this.printerLocator.getDefaultPrinter();
    }

    public DocumentPrinterServiceLocator getPrinterLocator() {
        return this.printerLocator;
    }

    public IArchetypeService getService() {
        return this.service;
    }

    public DocumentConverter getConverter() {
        return this.converter;
    }

    public Document getDecompressedDocument(Document document) {
        if (!(document instanceof CompressedDocumentImpl)) {
            document = new CompressedDocumentImpl(document, this.handlers);
        }
        return document;
    }
}

