/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.print;

import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.report.Reporter;
import org.openvpms.web.component.mail.MailDialog;
import org.openvpms.web.component.mail.MailEditor;
import org.openvpms.web.component.print.InteractivePrinter;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;

public class InteractiveIMPrinter<T>
extends InteractivePrinter
implements IMPrinter<T> {
    public InteractiveIMPrinter(IMPrinter<T> printer, Context context, HelpContext help) {
        this(printer, false, context, help);
    }

    public InteractiveIMPrinter(IMPrinter<T> printer, boolean skip, Context context, HelpContext help) {
        this(null, printer, skip, context, help);
    }

    public InteractiveIMPrinter(String title, IMPrinter<T> printer, Context context, HelpContext help) {
        this(title, printer, false, context, help);
    }

    public InteractiveIMPrinter(String title, IMPrinter<T> printer, boolean skip, Context context, HelpContext help) {
        super(title, printer, skip, context, help);
    }

    @Override
    public Iterable<T> getObjects() {
        return this.getPrinter().getObjects();
    }

    @Override
    public Reporter<T> getReporter() {
        return this.getPrinter().getReporter();
    }

    @Override
    protected IMPrinter<T> getPrinter() {
        return (IMPrinter)super.getPrinter();
    }

    @Override
    protected String getTitle() {
        String title = super.getTitle();
        if (title != null) {
            return title;
        }
        return Messages.format((String)"imobject.print.title", (Object[])new Object[]{this.getDisplayName()});
    }

    @Override
    protected void show(MailDialog dialog) {
        EmailTemplate emailTemplate;
        super.show(dialog);
        MailEditor editor = dialog.getMailEditor();
        Reporter<T> reporter = this.getReporter();
        editor.setObject(reporter.getObject());
        DocumentTemplate template = reporter.getTemplate();
        if (template != null && (emailTemplate = template.getEmailTemplate()) != null) {
            editor.setContent(emailTemplate);
        }
    }
}

