/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.print;

import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.print.IMObjectReportPrinter;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.ObjectSetReportPrinter;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.component.im.print.PrinterContextFactory;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.im.report.TemplatedReporter;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class IMPrinterFactory {
    private final ReporterFactory reporterFactory;
    private final ArchetypeHandlers<IMPrinter> printers;
    private final PrinterContext printerContext;
    private static final Logger log = LoggerFactory.getLogger(IMPrinterFactory.class);

    public IMPrinterFactory(ReporterFactory reporterFactory, PrinterContextFactory printerContextFactory, IArchetypeService service) {
        this.reporterFactory = reporterFactory;
        this.printers = new ArchetypeHandlers("IMPrinterFactory.properties", IMPrinter.class, (ArchetypeService)service);
        this.printerContext = printerContextFactory.create();
    }

    public <T extends IMObject> IMPrinter<T> create(T object, DocumentTemplateLocator locator, Context context) {
        String[] archetypes = new String[]{object.getArchetype()};
        archetypes = DescriptorHelper.getShortNames((String[])archetypes, (ArchetypeService)ServiceHelper.getArchetypeService());
        ArchetypeHandler handler = this.printers.getHandler(archetypes);
        IMPrinter<T> result = null;
        if (handler != null) {
            try {
                DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
                beanFactory.registerSingleton("object", object);
                beanFactory.registerSingleton("locator", (Object)locator);
                beanFactory.registerSingleton("printerContext", (Object)this.printerContext);
                beanFactory.registerSingleton("context", (Object)context);
                beanFactory.registerSingleton("factory", (Object)this.reporterFactory);
                Object printer = beanFactory.createBean(handler.getType(), 3, false);
                if (!IMPrinter.class.isAssignableFrom(printer.getClass())) {
                    log.error("Class of type " + printer.getClass().getName() + " is not an instance of " + IMPrinter.class.getName());
                    result = null;
                } else {
                    result = (IMPrinter)printer;
                }
            }
            catch (Throwable exception) {
                log.error(exception.getMessage(), exception);
            }
        }
        if (result == null) {
            result = this.createIMObjectReportPrinter(object, locator, context);
        }
        return result;
    }

    public <T extends IMObject> IMObjectReportPrinter<T> createIMObjectReportPrinter(T object, DocumentTemplateLocator locator, Context context) {
        return new IMObjectReportPrinter<T>(object, locator, this.printerContext, context, this.reporterFactory);
    }

    public <T extends IMObject> IMObjectReportPrinter<T> createIMObjectReportPrinter(Iterable<T> objects, DocumentTemplateLocator locator, Context context) {
        return new IMObjectReportPrinter<T>(objects, locator, this.printerContext, context, this.reporterFactory);
    }

    public <T extends IMObject, R extends TemplatedReporter<T>> IMObjectReportPrinter<T> createIMObjectReportPrinter(R reporter, Context context) {
        return new IMObjectReportPrinter(reporter, this.printerContext, context);
    }

    public ObjectSetReportPrinter createObjectSetReportPrinter(Iterable<ObjectSet> set, DocumentTemplateLocator locator, Context context) {
        return new ObjectSetReportPrinter(set, locator, this.printerContext, context, this.reporterFactory);
    }
}

