/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.patient;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.ObjectSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractEntityResultSet;
import org.openvpms.web.component.im.query.ObjectSetQueryExecutor;

public class PatientResultSet
extends AbstractEntityResultSet<ObjectSet> {
    private Reference customer;
    private String customerValue;
    private String contactValue;

    public PatientResultSet(ShortNameConstraint archetypes, String value, boolean searchIdentities, Reference customer, IConstraint constraints, SortConstraint[] sort, int rows) {
        super(archetypes, value, searchIdentities, constraints, sort, rows, false, new ObjectSetQueryExecutor());
        archetypes.setAlias("patient");
        this.customer = customer;
    }

    public PatientResultSet(ShortNameConstraint archetypes, String value, boolean searchIdentities, Reference customer, String customerValue, String contactValue, IConstraint constraints, SortConstraint[] sort, int rows) {
        super(archetypes, value, searchIdentities, constraints, sort, rows, false, new ObjectSetQueryExecutor());
        archetypes.setAlias("patient");
        this.customer = customer;
        this.customerValue = customerValue;
        this.contactValue = contactValue;
    }

    public boolean isSearchingAllPatients() {
        return this.customer == null;
    }

    public boolean isSearchingByContact() {
        return !StringUtils.isEmpty((CharSequence)this.contactValue);
    }

    @Override
    protected ArchetypeQuery createQuery() {
        ArchetypeQuery query = super.createQuery();
        query.add((IConstraint)new ObjectSelectConstraint("patient"));
        query.add((IConstraint)new ObjectSelectConstraint("customer"));
        boolean customerDetails = this.customer != null || !StringUtils.isEmpty((CharSequence)this.customerValue) || this.isSearchingByContact();
        Date now = new Date();
        ShortNameConstraint owner = Constraints.shortName((String)"rel", (String)"entityRelationship.patientOwner");
        JoinConstraint customers = customerDetails ? Constraints.join((String)"customers", (BaseArchetypeConstraint)owner) : Constraints.leftJoin((String)"customers", (BaseArchetypeConstraint)owner);
        JoinConstraint source = customerDetails ? Constraints.join((String)"source", (String)"customer") : Constraints.leftJoin((String)"source", (String)"customer");
        customers.add((IConstraint)source);
        query.add((IConstraint)customers);
        if (customerDetails) {
            if (this.customer != null) {
                query.add((IConstraint)Constraints.eq((String)"rel.source", (Reference)this.customer));
            } else if (!StringUtils.isEmpty((CharSequence)this.customerValue)) {
                Long id = this.getId(this.customerValue);
                if (id != null) {
                    source.add((IConstraint)Constraints.eq((String)"id", (Object)id));
                } else {
                    source.add((IConstraint)Constraints.eq((String)"name", (Object)this.customerValue));
                }
            }
            if (!StringUtils.isEmpty((CharSequence)this.contactValue)) {
                source.add((IConstraint)Constraints.join((String)"contacts", (String)"contact").add((IConstraint)Constraints.eq((String)"description", (Object)this.contactValue)));
                query.add((IConstraint)new ObjectSelectConstraint("contact"));
            }
            if (this.getArchetypes().isActiveOnly()) {
                query.add((IConstraint)Constraints.lte((String)"rel.activeStartTime", (Object)now));
                query.add((IConstraint)Constraints.or((IConstraint[])new IConstraint[]{Constraints.gte((String)"rel.activeEndTime", (Object)now), Constraints.isNull((String)"rel.activeEndTime")}));
            }
        }
        if (this.isSearchingIdentities()) {
            query.add((IConstraint)new ObjectSelectConstraint("identity"));
        }
        return query;
    }
}

