/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.patient;

import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientQuery;
import org.openvpms.web.component.im.patient.PatientResultSet;
import org.openvpms.web.component.im.patient.PatientTableModel;
import org.openvpms.web.component.im.query.AbstractQueryBrowser;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserAdapter;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.system.ServiceHelper;

public class PatientBrowser
extends BrowserAdapter<ObjectSet, Party> {
    public PatientBrowser(PatientQuery query, LayoutContext context) {
        this.setBrowser(PatientBrowser.createBrowser(query, context));
    }

    public Party getCustomer() {
        Party result = null;
        Party patient = (Party)this.getSelected();
        if (patient != null) {
            PatientRules rules = ServiceHelper.getBean(PatientRules.class);
            result = rules.getOwner(patient);
        }
        return result;
    }

    @Override
    protected Party convert(ObjectSet set) {
        return (Party)set.get("patient");
    }

    private static Browser<ObjectSet> createBrowser(final PatientQuery query, LayoutContext context) {
        final PatientTableModel model = new PatientTableModel(context.getContext());
        Query delegate = query.getQuery();
        return new AbstractQueryBrowser<ObjectSet>(delegate, delegate.getDefaultSortConstraint(), (IMTableModel)model, context){

            @Override
            protected ResultSet<ObjectSet> doQuery() {
                ResultSet<ObjectSet> result = super.doQuery();
                if (result instanceof PatientResultSet) {
                    PatientResultSet set = (PatientResultSet)result;
                    boolean active = query.getActive() == BaseArchetypeConstraint.State.BOTH;
                    model.showColumns(set.isSearchingAllPatients(), set.isSearchingIdentities(), active);
                }
                return result;
            }
        };
    }
}

