/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.patient;

import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.im.edit.act.AbstractActEditor;
import org.openvpms.web.component.im.layout.LayoutContext;

public class PatientActEditor
extends AbstractActEditor {
    private static final String PATIENT = "patient";
    private static final String CLINICIAN = "clinician";

    public PatientActEditor(Act act, Act parent, LayoutContext context) {
        super(act, (IMObject)parent, context);
        if (act.isNew()) {
            if (parent != null) {
                act.setActivityStartTime(parent.getActivityStartTime());
                IMObjectBean bean = this.getBean((IMObject)parent);
                if (bean.hasNode(PATIENT)) {
                    this.setPatient(bean.getTargetRef(PATIENT));
                } else {
                    this.initParticipant(PATIENT, (IMObject)context.getContext().getPatient());
                }
            } else {
                this.initParticipant(PATIENT, (IMObject)context.getContext().getPatient());
            }
            this.initParticipant(CLINICIAN, (IMObject)context.getContext().getClinician());
        }
    }

    public void setPatient(Party patient) {
        this.setPatient(patient != null ? patient.getObjectReference() : null);
    }

    public Party getPatient() {
        return (Party)this.getParticipant(PATIENT);
    }

    public void setPatient(Reference patient) {
        this.setParticipant(PATIENT, patient);
    }

    public Reference getPatientRef() {
        return this.getParticipantRef(PATIENT);
    }

    public void setClinician(User clinician) {
        this.setParticipant(CLINICIAN, (Entity)clinician);
    }

    public void setClinician(IMObjectReference clinician) {
        this.setParticipant(CLINICIAN, (Reference)clinician);
    }

    public Reference getClinicianRef() {
        return this.getParticipantRef(CLINICIAN);
    }
}

