/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.web.component.im.lookup.AbstractLookupQuery;
import org.openvpms.web.system.ServiceHelper;

public class ArchetypeLookupQuery
extends AbstractLookupQuery {
    private final String archetype;
    private final String[] codes;

    public ArchetypeLookupQuery(String archetype) {
        this(archetype, new String[0]);
    }

    public ArchetypeLookupQuery(String archetype, String[] codes) {
        this.archetype = archetype;
        this.codes = codes;
    }

    @Override
    public List<Lookup> getLookups() {
        Collection lookups = ServiceHelper.getLookupService().getLookups(this.archetype);
        ArrayList<Lookup> result = new ArrayList<Lookup>(lookups);
        if (this.codes.length != 0) {
            result.removeIf(lookup -> !ArrayUtils.contains((Object[])this.codes, (Object)lookup.getCode()));
        }
        this.sort(result);
        return result;
    }
}

