/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.list;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.web.component.im.list.ObjectListModel;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupListModel
extends ObjectListModel<Lookup> {
    private final LookupQuery source;
    private static final Logger log = LoggerFactory.getLogger(LookupListModel.class);

    public LookupListModel(LookupQuery source) {
        this(source, false);
    }

    public LookupListModel(LookupQuery source, boolean addAll) {
        this(source, addAll, false);
    }

    public LookupListModel(LookupQuery source, boolean addAll, boolean addNone) {
        this(source, addAll, addNone, false);
    }

    public LookupListModel(LookupQuery source, boolean addAll, boolean addNone, boolean addDefault) {
        super(new ArrayList(), addAll, addNone, addDefault);
        this.source = source;
        this.setObjects(this.getLookups());
    }

    @Override
    public Object get(int index) {
        Lookup lookup = this.getLookup(index);
        return lookup != null ? lookup.getCode() : null;
    }

    public Lookup getLookup(int index) {
        return (Lookup)this.getObject(index);
    }

    @Override
    public int indexOf(String lookup) {
        int result = -1;
        List lookups = this.getObjects();
        for (int i = 0; i < lookups.size(); ++i) {
            Lookup other = (Lookup)lookups.get(i);
            if ((other == null || !StringUtils.equals((CharSequence)lookup, (CharSequence)other.getCode())) && (other != null || lookup != null)) continue;
            result = i;
            break;
        }
        return result;
    }

    public boolean refresh() {
        List<Lookup> lookups;
        List<Lookup> current;
        boolean refreshed = false;
        if (this.source != null && !(current = this.getCurrentLookups()).equals(lookups = this.getLookups())) {
            this.setObjects(lookups);
            refreshed = true;
        }
        return refreshed;
    }

    public Lookup getDefaultLookup() {
        return this.source.getDefault();
    }

    private List<Lookup> getLookups() {
        try {
            return this.source.getLookups();
        }
        catch (OpenVPMSException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return new ArrayList<Lookup>();
        }
    }

    private List<Lookup> getCurrentLookups() {
        ArrayList<Lookup> result = new ArrayList<Lookup>();
        for (Lookup lookup : this.getObjects()) {
            if (lookup == null) continue;
            result.add(lookup);
        }
        return result;
    }
}

