/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.layout;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.focus.FocusHelper;

public class ComponentSet {
    private final List<ComponentState> components = new ArrayList<ComponentState>();
    private final FocusGroup focusGroup;

    public ComponentSet() {
        this(null);
    }

    public ComponentSet(FocusGroup focusGroup) {
        this.focusGroup = focusGroup;
    }

    public void add(ComponentState component) {
        this.add(this.components.size(), component);
    }

    public void add(int index, ComponentState component) {
        this.components.add(index, component);
    }

    public int indexOf(String name) {
        for (int i = 0; i < this.components.size(); ++i) {
            ComponentState state = this.components.get(i);
            if (state.getProperty() == null || !name.equals(state.getProperty().getName())) continue;
            return i;
        }
        return -1;
    }

    public ComponentState get(String name) {
        int index = this.indexOf(name);
        return index != -1 ? this.components.get(index) : null;
    }

    public List<ComponentState> getComponents() {
        return this.components;
    }

    public int size() {
        return this.components.size();
    }

    public void setFocusTraversal(ComponentState state) {
        Component component = state.getComponent();
        if (state.getFocusGroup() != null) {
            this.components.add(state);
            this.focusGroup.add(state.getFocusGroup());
        } else {
            Component focusable = FocusHelper.getFocusable((Component)component);
            if (focusable != null) {
                this.components.add(state);
                this.focusGroup.add(focusable);
            }
        }
    }

    public Component getFocusable() {
        Component result = null;
        for (ComponentState state : this.components) {
            Component child = state.getFocusable();
            if (child == null) continue;
            Property property = state.getProperty();
            if (property != null && !property.isValid()) {
                result = child;
                break;
            }
            if (result != null) continue;
            result = child;
        }
        return result;
    }

    public Component getFocusable(String name) {
        for (ComponentState state : this.components) {
            Property property = state.getProperty();
            if (property == null || !name.equals(property.getName())) continue;
            return state.getFocusable();
        }
        return null;
    }
}

