/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.filter;

import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.filter.NodeFilter;

public class BasicNodeFilter
implements NodeFilter {
    private final boolean showOptional;
    private final boolean showHidden;

    public BasicNodeFilter(boolean showOptional) {
        this(showOptional, false);
    }

    public BasicNodeFilter(boolean showOptional, boolean showHidden) {
        this.showOptional = showOptional;
        this.showHidden = showHidden;
    }

    public boolean showOptional() {
        return this.showOptional;
    }

    public boolean showHidden() {
        return this.showHidden;
    }

    @Override
    public boolean include(NodeDescriptor descriptor, IMObject object) {
        boolean result = false;
        if (descriptor.isHidden()) {
            if (this.showHidden()) {
                result = true;
            }
        } else {
            result = this.showOptional() ? true : descriptor.isRequired();
        }
        return result;
    }
}

