/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.payment;

import echopointng.HttpPaneEx;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.eftpos.internal.event.EFTPOSEventMonitor;
import org.openvpms.eftpos.service.WebTransactionDisplay;
import org.openvpms.eftpos.transaction.Receipt;
import org.openvpms.eftpos.transaction.Transaction;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.util.ApplicationInstanceConsumer;
import org.openvpms.web.echo.util.TaskQueues;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class WebEFTPaymentDialog
extends ModalDialog {
    private final WebTransactionDisplay display;
    private final EFTPOSEventMonitor monitor;
    private ApplicationInstanceConsumer<Receipt> printListener;
    private ApplicationInstanceConsumer<Transaction> completionListener;

    public WebEFTPaymentDialog(WebTransactionDisplay display, HelpContext help) {
        super(Messages.get((String)"customer.payment.eft.title"), new String[]{"cancel"}, help);
        this.display = display;
        this.setContentWidth(display.getWidth());
        this.setContentHeight(display.getHeight());
        this.monitor = ServiceHelper.getBean(EFTPOSEventMonitor.class);
    }

    public void show() {
        super.show();
        this.printListener = new ApplicationInstanceConsumer(0, TaskQueues.QueueMode.QUEUE_LAST, this::onPrint);
        this.completionListener = new ApplicationInstanceConsumer(0, TaskQueues.QueueMode.QUEUE_LAST, this::onCompleted);
        this.monitor.addTransactionListener(this.display.getTransaction(), this.completionListener);
        HttpPaneEx frame = new HttpPaneEx(this.display.getUrl());
        this.getLayout().add((Component)frame);
    }

    public void dispose() {
        super.dispose();
        if (this.printListener != null) {
            this.printListener.dispose();
        }
        if (this.completionListener != null) {
            this.completionListener.dispose();
        }
    }

    private void onPrint(Receipt receipt) {
        InformationDialog.show((String)"Merchant Receipt", (String)receipt.getReceipt(), (WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                WebEFTPaymentDialog.this.close("ok");
            }
        });
    }

    private void onCompleted(Transaction transaction) {
        if (this.getParent() != null) {
            if (transaction.getStatus() == Transaction.Status.APPROVED) {
                InformationDialog.show((String)"Transaction complete", (WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        WebEFTPaymentDialog.this.close("ok");
                    }
                });
            } else {
                ErrorDialog.show((String)"EFT", (String)("Failed to perform transaction: " + transaction.getStatus()), (WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        WebEFTPaymentDialog.this.close("cancel");
                    }
                });
            }
        }
    }
}

