/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.payment;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.supplier.account.SupplierAccountRules;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.act.ActHelper;
import org.openvpms.web.component.im.edit.payment.PaymentEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectCreationListener;
import org.openvpms.web.system.ServiceHelper;

public class SupplierPaymentEditor
extends PaymentEditor {
    public SupplierPaymentEditor(FinancialAct act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
        this.initParticipant("supplier", (IMObject)context.getContext().getSupplier());
        this.getItems().setCreationListener(new IMObjectCreationListener(){

            @Override
            public void created(IMObject object) {
                SupplierPaymentEditor.this.onCreated((FinancialAct)object);
            }
        });
    }

    private void onCreated(FinancialAct act) {
        Party supplier;
        if (TypeHelper.isA((IMObject)act, (String)"act.supplierAccountPayment*") && (supplier = (Party)this.getParticipant("supplier")) != null) {
            FinancialAct parent = this.getObject();
            BigDecimal diff = ActHelper.sum((Act)parent, "amount");
            SupplierAccountRules rules = ServiceHelper.getBean(SupplierAccountRules.class);
            BigDecimal current = rules.getBalance(supplier);
            BigDecimal balance = current.subtract(diff);
            act.setTotal((BigDecimal)new Money(balance));
            this.getItems().setModified((Act)act, true);
        }
    }
}

