/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import java.util.List;
import java.util.Map;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.relationship.RelationshipCollectionTargetPropertyEditor;
import org.openvpms.web.component.im.relationship.SequencedRelationshipCollectionHelper;
import org.openvpms.web.component.property.CollectionProperty;

public class ActRelationshipCollectionPropertyEditor
extends RelationshipCollectionTargetPropertyEditor<ActRelationship> {
    public ActRelationshipCollectionPropertyEditor(CollectionProperty property, Act act, IMObjects objects) {
        super(property, (IMObject)act, objects);
        List sorted = SequencedRelationshipCollectionHelper.sort(this.getRelationships());
        SequencedRelationshipCollectionHelper.sequence(sorted);
    }

    public ActRelationship getRelationship(Act target) {
        return (ActRelationship)this.getTargets().get(target);
    }

    public Map<Act, ActRelationship> getActs() {
        return super.getTargets();
    }

    @Override
    protected ActRelationship addRelationship(IMObject source, IMObject target, String shortName) {
        IArchetypeService service = this.getService();
        ActRelationship relationship = (ActRelationship)service.create(shortName, ActRelationship.class);
        relationship.setSource(source.getObjectReference());
        relationship.setTarget(target.getObjectReference());
        ((Act)source).addActRelationship(relationship);
        ((Act)target).addActRelationship(relationship);
        int sequence = SequencedRelationshipCollectionHelper.getNextSequence(this.getRelationships());
        relationship.setSequence(sequence);
        return relationship;
    }

    @Override
    protected boolean removeRelationship(IMObject source, IMObject target, ActRelationship relationship) {
        Act targetAct = (Act)target;
        targetAct.removeActRelationship(relationship);
        return this.getProperty().remove(relationship);
    }
}

