/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import org.openvpms.archetype.rules.act.ActStatusHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditActions;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.system.ServiceHelper;

public class ActEditDialog
extends EditDialog {
    private boolean posted;
    private ModifiableListener statusListener;

    public ActEditDialog(IMObjectEditor editor, Context context) {
        super(editor, context);
    }

    public ActEditDialog(IMObjectEditor editor, EditActions actions, Context context) {
        super(editor, actions, context);
    }

    @Override
    protected boolean canSave() {
        return super.canSave() && (this.getEditor().getObject().isNew() || !this.posted);
    }

    protected boolean isPosted() {
        return this.posted;
    }

    @Override
    protected void doSave(IMObjectEditor editor) {
        super.doSave(editor);
        if (!this.posted) {
            this.posted = this.getPosted();
        }
    }

    @Override
    protected void setEditor(IMObjectEditor editor) {
        if (editor != null) {
            Property status;
            if (this.statusListener != null) {
                Property status2;
                IMObjectEditor old = this.getEditor();
                if (old != null && (status2 = editor.getProperty("status")) != null) {
                    status2.removeModifiableListener(this.statusListener);
                }
                this.statusListener = null;
            }
            if ((status = editor.getProperty("status")) != null) {
                this.onStatusChanged(status);
                this.statusListener = modifiable -> this.onStatusChanged(status);
                status.addModifiableListener(this.statusListener);
            }
        }
        super.setEditor(editor);
        this.posted = this.isSavedPosted();
    }

    @Override
    protected boolean reload(IMObjectEditor editor) {
        boolean result = super.reload(editor);
        if (result) {
            IMObjectEditor newEditor = this.getEditor();
            result = newEditor.getObject().isNew() || !this.isPosted();
        }
        return result;
    }

    private void onStatusChanged(Property status) {
        if ("POSTED".equals(status.getString())) {
            this.getButtons().setEnabled("apply", false);
        } else if (!this.isSaveDisabled()) {
            this.getButtons().setEnabled("apply", true);
        }
    }

    private boolean getPosted() {
        boolean result = false;
        IMObjectEditor editor = this.getEditor();
        if (editor != null) {
            Act act = (Act)editor.getObject();
            result = !act.isNew() && "POSTED".equals(act.getStatus());
        }
        return result;
    }

    private boolean isSavedPosted() {
        boolean result = false;
        IMObjectEditor editor = this.getEditor();
        if (editor != null) {
            Act act = (Act)editor.getObject();
            result = ActStatusHelper.isPosted((Act)act, (ArchetypeService)ServiceHelper.getArchetypeService());
        }
        return result;
    }
}

