/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorSaver;
import org.openvpms.web.component.im.util.DefaultIMObjectSaveListener;
import org.openvpms.web.component.im.util.IMObjectSaveListener;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.springframework.transaction.support.TransactionTemplate;

public class SaveHelper {
    public static boolean save(IMObjectEditor editor) {
        IMObjectEditorSaver saver = new IMObjectEditorSaver();
        return saver.save(editor);
    }

    public static boolean save(IMObjectEditor editor, final Runnable callback) {
        IMObjectEditorSaver.SaveOperation strategy = new IMObjectEditorSaver.SaveOperation(){

            @Override
            public void apply(IMObjectEditor editor) {
                super.apply(editor);
                callback.run();
            }
        };
        IMObjectEditorSaver saver = new IMObjectEditorSaver(strategy);
        return saver.save(editor);
    }

    public static boolean save(IMObject object) {
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        return SaveHelper.save(object, (IArchetypeService)service);
    }

    public static boolean save(IMObject object, IArchetypeService service) {
        return SaveHelper.save(Collections.singletonList(object), service);
    }

    public static boolean save(IMObject ... objects) {
        return SaveHelper.save(Arrays.asList(objects));
    }

    public static boolean save(Collection<? extends IMObject> objects) {
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        return SaveHelper.save(objects, (IArchetypeService)service);
    }

    public static boolean save(Collection<? extends IMObject> objects, IArchetypeService service) {
        return SaveHelper.save(objects, DefaultIMObjectSaveListener.INSTANCE, service);
    }

    public static boolean save(Collection<? extends IMObject> objects, IMObjectSaveListener listener) {
        return SaveHelper.save(objects, listener, (IArchetypeService)ServiceHelper.getArchetypeService());
    }

    public static boolean save(Collection<? extends IMObject> objects, IMObjectSaveListener listener, IArchetypeService service) {
        boolean saved = false;
        try {
            service.save(objects);
            listener.saved(objects);
            saved = true;
        }
        catch (Throwable exception) {
            listener.error(objects, exception);
        }
        return saved;
    }

    public static boolean replace(IMObject delete, IMObject insert) {
        Boolean result = null;
        try {
            TransactionTemplate template = new TransactionTemplate(ServiceHelper.getTransactionManager());
            result = (Boolean)template.execute(status -> {
                IArchetypeRuleService service = ServiceHelper.getArchetypeService();
                service.remove(delete);
                service.save(insert);
                return true;
            });
        }
        catch (Throwable exception) {
            String title = Messages.get((String)"imobject.replace.failed.title");
            ErrorHelper.show(title, exception);
        }
        return result != null && result != false;
    }
}

