/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.ContextHelper;
import org.openvpms.web.component.im.edit.AbstractIMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.property.Property;

public class PatientReferenceEditor
extends AbstractIMObjectReferenceEditor<Party> {
    private boolean allPatients;

    public PatientReferenceEditor(Property property, IMObject parent, LayoutContext context) {
        this(property, parent, context, false);
    }

    public PatientReferenceEditor(Property property, IMObject parent, LayoutContext context, boolean allPatients) {
        super(property, parent, context);
        this.allPatients = allPatients;
    }

    @Override
    public boolean setObject(Party object) {
        ContextHelper.setPatient(this.getContext(), object);
        return super.setObject(object);
    }

    public void setAllPatients(boolean all) {
        this.allPatients = all;
    }

    @Override
    protected Query<Party> createQuery(String name) {
        Query<Party> query = super.createQuery(name);
        if (query instanceof PatientQuery) {
            PatientQuery patientQuery = (PatientQuery)query;
            patientQuery.setShowAllPatients(this.allPatients);
            if (this.allPatients) {
                patientQuery.setQueryAllPatients(true);
            }
        }
        return query;
    }
}

