/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import echopointng.GroupBox;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.archetype.ArchetypeRange;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.AbstractEditableIMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.DefaultRemoveConfirmationHandler;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.RemoveConfirmationHandler;
import org.openvpms.web.component.im.filter.ChainedNodeFilter;
import org.openvpms.web.component.im.filter.FilterHelper;
import org.openvpms.web.component.im.filter.NamedNodeFilter;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.layout.LayoutHelper;
import org.openvpms.web.component.im.list.ShortNameListCellRenderer;
import org.openvpms.web.component.im.list.ShortNameListModel;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.util.IMObjectCreationListener;
import org.openvpms.web.component.im.view.DefaultIMObjectComponent;
import org.openvpms.web.component.im.view.IMObjectComponent;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GroupBoxFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.keyboard.KeyStrokeHelper;
import org.openvpms.web.echo.table.SortableTableModel;
import org.openvpms.web.echo.table.TableNavigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IMTableCollectionEditor<T>
extends AbstractEditableIMObjectCollectionEditor {
    public static final String ADD_ID = "add";
    public static final String DELETE_ID = "delete";
    protected static final int ROWS = 15;
    private final PropertyChangeListener componentListener;
    private final ModifiableListener editorListener;
    private Column container;
    private PagedIMTable<T> table;
    private String shortName;
    private GroupBox editBox;
    private FocusGroup focusGroup;
    private FocusGroup editorFocusGroup;
    private boolean editorModified;
    private ButtonRow buttons;
    private SelectField archetypeSelector;
    private static final Logger log = LoggerFactory.getLogger(IMTableCollectionEditor.class);
    private static final String PREVIOUS_ID = "previous";
    private static final String NEXT_ID = "next";

    public IMTableCollectionEditor(CollectionPropertyEditor editor, IMObject object, LayoutContext layoutContext) {
        super(editor, object, (LayoutContext)new DefaultLayoutContext(layoutContext));
        LayoutContext context = this.getContext();
        context.setLayoutDepth(layoutContext.getLayoutDepth());
        NamedNodeFilter idFilter = new NamedNodeFilter("id");
        ChainedNodeFilter filter = FilterHelper.chain(idFilter, layoutContext.getDefaultNodeFilter());
        context.setNodeFilter(filter);
        this.componentListener = event -> this.onComponentChange();
        this.editorListener = modifiable -> this.onCurrentEditorModified();
    }

    @Override
    public IMObject create() {
        return this.create(this.shortName);
    }

    @Override
    public IMObject create(String archetype) {
        IMObjectCreationListener creationListener;
        IMObject object = super.create(archetype);
        if (object != null && (creationListener = this.getCreationListener()) != null) {
            creationListener.created(object);
        }
        return object;
    }

    public IMObjectEditor add() {
        return this.add(this.shortName);
    }

    public IMObjectEditor add(String shortName) {
        IMObject object;
        IMObjectEditor editor = null;
        if (this.addCurrentEdits(new DefaultValidator()) && (object = this.create(shortName)) != null) {
            editor = this.edit(object);
            this.addCurrentEdits(new DefaultValidator());
        }
        return editor;
    }

    @Override
    public void remove(IMObject object) {
        IMObjectEditor editor = this.getCurrentEditor();
        if (editor != null && editor.getObject() == object) {
            this.removeCurrentEditor();
        }
        CollectionPropertyEditor collection = this.getCollectionPropertyEditor();
        boolean present = collection.getObjects().contains(object);
        boolean removed = collection.remove(object);
        if (removed && this.selectNext() == null) {
            this.selectPrevious();
        }
        this.refresh();
        if (!present || !removed) {
            this.getListeners().notifyListeners(this.getProperty());
        }
        KeyStrokeHelper.reregisterKeyStrokeListeners((Component)this.container);
    }

    @Override
    public void refresh() {
        this.refresh(true);
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    protected abstract IMTableModel<T> createTableModel(LayoutContext var1);

    protected PagedIMTable<T> createTable(IMTableModel<T> model) {
        return new PagedIMTable<T>(model);
    }

    protected void refresh(boolean preserveSelection) {
        if (this.table != null) {
            if (preserveSelection) {
                IMObject object = this.getSelected();
                this.populateTable();
                this.setSelected(object);
            } else {
                this.populateTable();
            }
            this.enableNavigation(true);
        }
    }

    protected abstract void setSelected(IMObject var1);

    protected abstract IMObject getSelected();

    protected IMObject getSelectionTarget(IMObject object) {
        return object;
    }

    protected abstract IMObject selectPrevious();

    protected abstract IMObject selectNext();

    protected abstract ResultSet<T> createResultSet();

    @Override
    protected Component doLayout(LayoutContext context) {
        this.container = new IMObjectCollectionComponent();
        this.container.setStyleName("CellSpacing");
        this.focusGroup = new FocusGroup(ClassUtils.getShortClassName(this.getClass()));
        this.table = this.createTable(this.createTableModel(context));
        this.table.getTable().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                IMTableCollectionEditor.this.onSelected();
            }
        });
        this.doLayout((Component)this.container, context);
        if (this.getObject().isNew()) {
            this.createEditors();
        }
        return this.container;
    }

    protected void createEditors() {
        CollectionPropertyEditor collectionPropertyEditor = this.getCollectionPropertyEditor();
        for (IMObject object : collectionPropertyEditor.getObjects()) {
            this.getEditor(object);
        }
    }

    protected void doLayout(Component container, LayoutContext context) {
        if (!this.isCardinalityReadOnly()) {
            ButtonRow row = this.createControls(this.focusGroup);
            container.add((Component)row);
        }
        this.refresh();
        this.focusGroup.add(this.table.getFocusGroup());
        container.add(this.table.getComponent());
    }

    protected ButtonRow createControls(FocusGroup focus) {
        this.buttons = new ButtonRow(focus);
        this.addButtons(this.buttons);
        this.addArchetypeSelector(this.buttons, focus);
        return this.buttons;
    }

    protected boolean canAdd() {
        return true;
    }

    protected boolean canRemove() {
        return true;
    }

    protected boolean showPreviousNext() {
        return true;
    }

    protected void addButtons(ButtonRow buttons) {
        int cardinality;
        boolean disableShortcut;
        boolean bl = disableShortcut = this.getContext().getLayoutDepth() > 1;
        if (this.canAdd()) {
            ActionListener addListener = new ActionListener(){

                public void onAction(ActionEvent event) {
                    IMTableCollectionEditor.this.onAdd();
                }
            };
            buttons.addButton(ADD_ID, disableShortcut, (nextapp.echo2.app.event.ActionListener)addListener);
        }
        if (this.canRemove()) {
            ActionListener deleteListener = new ActionListener(){

                public void onAction(ActionEvent event) {
                    IMTableCollectionEditor.this.onDelete();
                }
            };
            buttons.addButton(DELETE_ID, disableShortcut, (nextapp.echo2.app.event.ActionListener)deleteListener);
        }
        if (this.showPreviousNext() && ((cardinality = this.getCollection().getMaxCardinality()) > 1 || cardinality == -1)) {
            ActionListener previous = new ActionListener(){

                public void onAction(ActionEvent event) {
                    IMTableCollectionEditor.this.onPrevious();
                }
            };
            buttons.addButton(PREVIOUS_ID, disableShortcut, (nextapp.echo2.app.event.ActionListener)previous);
            ActionListener next = new ActionListener(){

                public void onAction(ActionEvent event) {
                    IMTableCollectionEditor.this.onNext();
                }
            };
            buttons.addButton(NEXT_ID, disableShortcut, (nextapp.echo2.app.event.ActionListener)next);
        }
    }

    protected void addArchetypeSelector(ButtonRow buttons, FocusGroup focus) {
        ArchetypeRange range = this.getCollectionPropertyEditor().getArchetypes();
        List archetypes = range.getArchetypes();
        if (archetypes.size() == 1) {
            this.shortName = (String)archetypes.get(0);
        } else if (archetypes.size() > 1) {
            final ShortNameListModel model = new ShortNameListModel(archetypes, false, false);
            this.archetypeSelector = SelectFieldFactory.create((ListModel)model);
            if (range.getDefaultArchetype() != null) {
                this.archetypeSelector.setSelectedItem((Object)range.getDefaultArchetype());
            }
            int index = this.archetypeSelector.getSelectedIndex();
            this.shortName = model.getShortName(index);
            this.archetypeSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    int index = IMTableCollectionEditor.this.archetypeSelector.getSelectedIndex();
                    if (index != -1) {
                        IMTableCollectionEditor.this.shortName = model.getShortName(index);
                    }
                }
            });
            this.archetypeSelector.setCellRenderer((ListCellRenderer)new ShortNameListCellRenderer());
            buttons.add((Component)this.archetypeSelector);
            focus.add((Component)this.archetypeSelector);
        }
    }

    protected void setArchetype(String archetype) {
        Object[] range = this.getCollectionPropertyEditor().getArchetypeRange();
        if (ArrayUtils.contains((Object[])(range = DescriptorHelper.getShortNames((String[])range, (boolean)false, (ArchetypeService)this.getService())), (Object)archetype)) {
            if (this.archetypeSelector != null) {
                this.archetypeSelector.setSelectedItem((Object)archetype);
                int index = this.archetypeSelector.getSelectedIndex();
                this.shortName = ((ShortNameListModel)this.archetypeSelector.getModel()).getShortName(index);
            } else {
                this.shortName = archetype;
            }
        }
    }

    @Override
    protected boolean addEdited(IMObjectEditor editor) {
        boolean added = super.addEdited(editor);
        if (added || this.editorModified || editor != this.getCurrentEditor()) {
            if (editor == this.getCurrentEditor()) {
                this.editorModified = false;
            }
            this.refresh(false);
        }
        IMObject object = editor.getObject();
        this.setSelected(object);
        return added;
    }

    protected String getShortName() {
        return this.shortName;
    }

    protected IMObjectEditor onAdd() {
        return this.add();
    }

    protected void onDelete() {
        IMObjectEditor editor = this.getCurrentEditor();
        IMObject object = editor != null ? editor.getObject() : this.getSelected();
        if (object != null) {
            RemoveConfirmationHandler handler = this.getRemoveConfirmationHandler();
            if (handler == null) {
                handler = DefaultRemoveConfirmationHandler.INSTANCE;
            }
            handler.remove(object, this);
        }
    }

    protected void onSelected() {
        Object object = this.getSelected();
        if (object != null) {
            if (this.addCurrentEdits(new DefaultValidator())) {
                this.setSelected((IMObject)object);
                this.edit((IMObject)object);
            } else {
                IMObjectEditor current = this.getCurrentEditor();
                object = current != null ? current.getObject() : null;
                this.setSelected((IMObject)object);
                this.enableNavigation(false);
                if (current != null && current.getFocusGroup() != null) {
                    current.getFocusGroup().setFocus();
                }
            }
        }
    }

    protected IMObjectEditor edit(IMObject object) {
        IMObjectEditor editor = this.getCurrentEditor();
        if (editor != null) {
            editor.removePropertyChangeListener("component", this.componentListener);
            this.editBox.removeAll();
        } else {
            this.editBox = GroupBoxFactory.create();
            this.editBox.setInsets(new Insets(0));
        }
        this.container.add((Component)this.editBox);
        editor = this.getEditor(object);
        Component component = editor.getComponent();
        if (LayoutHelper.needsInset(component)) {
            component = ColumnFactory.create((String)"Inset", (Component[])new Component[]{component});
        }
        this.editBox.add(component);
        this.editBox.setTitle(editor.getTitle());
        editor.addPropertyChangeListener("component", this.componentListener);
        this.changeFocusGroup(editor);
        this.setCurrentEditor(editor);
        KeyStrokeHelper.reregisterKeyStrokeListeners((Component)this.container);
        this.enableNavigation(editor.isValid());
        return editor;
    }

    protected void onPrevious() {
        if (this.addCurrentEdits(new DefaultValidator())) {
            IMObject object = this.selectPrevious();
            if (object != null) {
                this.edit(object);
            }
        } else {
            this.enableNavigation(false);
        }
    }

    protected void onNext() {
        if (this.addCurrentEdits(new DefaultValidator())) {
            IMObject object = this.selectNext();
            if (object != null) {
                this.edit(object);
            }
        } else {
            this.enableNavigation(false);
        }
    }

    protected void populateTable() {
        SortableTableModel sortable;
        boolean ascending;
        IMTableModel<T> model = this.table.getTable().getModel();
        int sortColumn = -1;
        boolean bl = ascending = this.table.getResultSet() != null && this.table.getResultSet().isSortedAscending();
        if (model instanceof SortableTableModel) {
            SortableTableModel sortable2 = (SortableTableModel)model;
            sortColumn = sortable2.getSortColumn();
        }
        ResultSet<T> set = this.createResultSet();
        this.table.setResultSet(set);
        if (model instanceof SortableTableModel && (sortable = (SortableTableModel)model).getSortColumn() == -1) {
            if (sortColumn != -1) {
                sortable.sort(sortColumn, ascending);
            } else if (model.getDefaultSortColumn() != -1) {
                sortable.sort(model.getDefaultSortColumn(), model.getDefaultSortAscending());
            }
        }
    }

    protected PagedIMTable<T> getTable() {
        return this.table;
    }

    @Override
    protected void setCurrentEditor(IMObjectEditor editor) {
        IMObjectEditor current = this.getCurrentEditor();
        if (current != null) {
            current.removeModifiableListener(this.editorListener);
        }
        if (editor != null) {
            editor.addModifiableListener(this.editorListener);
        }
        super.setCurrentEditor(editor);
    }

    @Override
    protected void removeCurrentEditor() {
        IMObjectEditor editor = this.getCurrentEditor();
        this.focusGroup.remove(this.editorFocusGroup);
        this.editorFocusGroup = null;
        this.editBox.remove(editor.getComponent());
        this.container.remove((Component)this.editBox);
        editor.removePropertyChangeListener("component", this.componentListener);
        this.editorModified = false;
        this.editBox = null;
        super.removeCurrentEditor();
    }

    protected void onComponentChange() {
        this.editBox.removeAll();
        IMObjectEditor editor = this.getCurrentEditor();
        this.editBox.add(editor.getComponent());
        this.changeFocusGroup(editor);
    }

    protected void onCurrentEditorModified() {
        this.resetValid(false);
        this.editorModified = true;
        IMObjectEditor current = this.getCurrentEditor();
        boolean valid = current != null && current.isValid();
        this.enableNavigation(valid);
        this.getListeners().notifyListeners(this);
    }

    protected void enableNavigation(boolean enable) {
        this.enableNavigation(enable, enable);
    }

    protected void enableNavigation(boolean enable, boolean enableAdd) {
        if (this.buttons != null) {
            this.enableNavigation(this.buttons.getButtons(), enable, enableAdd);
        }
    }

    protected void enableNavigation(ButtonSet buttons, boolean enable, boolean enableAdd) {
        boolean add = enableAdd;
        boolean previous = enable;
        boolean next = enable;
        if (enable) {
            TableNavigator navigator = this.getTable().getNavigator();
            previous = navigator.hasPreviousRow();
            next = navigator.hasNextRow();
        }
        if (add) {
            CollectionProperty property = this.getCollection();
            int maxSize = property.getMaxCardinality();
            add = maxSize == -1 || property.size() < maxSize;
        }
        buttons.setEnabled(ADD_ID, add);
        buttons.setEnabled(PREVIOUS_ID, previous);
        buttons.setEnabled(NEXT_ID, next);
        this.enableDelete();
    }

    protected void enableDelete() {
        if (this.buttons != null) {
            this.buttons.getButtons().setEnabled(DELETE_ID, this.getEnableDelete());
        }
    }

    protected boolean getEnableDelete() {
        return this.getCurrentEditor() != null || this.getSelected() != null;
    }

    protected ButtonSet getButtons() {
        return this.buttons.getButtons();
    }

    private void changeFocusGroup(IMObjectEditor editor) {
        int index;
        if (this.editorFocusGroup == null) {
            index = this.focusGroup.size();
        } else {
            index = this.focusGroup.indexOf(this.editorFocusGroup);
            if (index == -1) {
                log.error("Missing focus group for existing editor");
                index = this.focusGroup.size();
            } else {
                this.focusGroup.remove(this.editorFocusGroup);
            }
        }
        this.editorFocusGroup = editor.getFocusGroup();
        if (this.editorFocusGroup != null) {
            this.focusGroup.add(index, this.editorFocusGroup);
            this.editorFocusGroup.setFocus();
        } else {
            log.warn("Editor " + editor.getClass().getName() + " for " + editor.getDisplayName() + " has no focus");
        }
    }

    private class IMObjectCollectionComponent
    extends Column
    implements IMObjectComponent {
        private IMObjectCollectionComponent() {
        }

        @Override
        public IMObject getObject() {
            return null;
        }

        @Override
        public String getNode() {
            return IMTableCollectionEditor.this.getProperty().getName();
        }

        @Override
        public IMObjectComponent getSelected() {
            IMObject object = IMTableCollectionEditor.this.getSelected();
            return object != null ? new DefaultIMObjectComponent(object, (Component)IMTableCollectionEditor.this.editBox) : null;
        }

        @Override
        public boolean select(Selection selection) {
            boolean result = false;
            IMObject object = IMTableCollectionEditor.this.getSelectionTarget(selection.getObject());
            IMTableCollectionEditor.this.setSelected(object);
            if (object != null && Objects.equals(object, IMTableCollectionEditor.this.getSelected())) {
                IMTableCollectionEditor.this.onSelected();
                result = true;
            }
            return result;
        }

        @Override
        public Component getComponent() {
            return IMTableCollectionEditor.this.editBox;
        }
    }
}

