/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.List;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.AbstractEditDialog;
import org.openvpms.web.component.im.edit.EditActions;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class EditResultSetDialog<T extends IMObject>
extends AbstractEditDialog {
    private final Context context;
    private final IMObjectActions<T> actions;
    private final ResultSetIterator<T> iter;
    private IMObjectViewer viewer;
    private static final String PREVIOUS_ID = "previous";
    private static final String NEXT_ID = "next";
    private static final String SAVE_ID = "save";
    private static final String REVERT_ID = "revert";
    private static final String[] BUTTONS = new String[]{"apply", "ok", "cancel", "previous", "next"};
    private static final String[] CONFIRMATION = new String[]{"save", "revert", "cancel"};

    public EditResultSetDialog(String title, T first, ResultSet<T> set, IMObjectActions<T> actions, Context context, HelpContext help) {
        super(title, EditActions.buttons(BUTTONS), context, help);
        this.context = context;
        this.actions = actions;
        this.setDefaultCloseAction("cancel");
        this.iter = new ResultSetIterator<T>(set, first);
        if (this.iter.hasNext()) {
            this.select((IMObject)this.iter.next());
        }
        this.enableButtons();
        this.setModal(true);
    }

    @Override
    protected void onOK() {
        if (this.getEditor() != null) {
            super.onOK();
        } else {
            this.close("ok");
        }
    }

    protected void onPrevious() {
        IMObjectEditor editor = this.getEditor();
        if (!this.checkModified(editor, false)) {
            this.previous();
        }
    }

    protected void onNext() {
        IMObjectEditor editor = this.getEditor();
        if (!this.checkModified(editor, true)) {
            this.next();
        }
    }

    protected void onButton(String button) {
        if (PREVIOUS_ID.equals(button)) {
            this.onPrevious();
        } else if (NEXT_ID.equals(button)) {
            this.onNext();
        } else {
            super.onButton(button);
        }
    }

    @Override
    protected void doSave(IMObjectEditor editor) {
        IMObject object;
        super.doSave(editor);
        if (editor != null && !this.actions.canEdit(object = editor.getObject())) {
            this.select(object);
        }
    }

    protected void enableButtons() {
        ButtonSet set = this.getButtons();
        IMObjectEditor editor = this.getEditor();
        set.setEnabled("apply", editor != null);
        set.setEnabled(PREVIOUS_ID, this.iter.lastIndex() > 0);
        set.setEnabled(NEXT_ID, this.iter.hasNext());
    }

    private boolean checkModified(IMObjectEditor editor, final boolean next) {
        boolean result = true;
        if (editor != null && editor.isModified()) {
            String title = Messages.get((String)"imobject.savechanges.title");
            String message = Messages.format((String)"imobject.savechanges.message", (Object[])new Object[]{editor.getDisplayName()});
            ConfirmationDialog dialog = new ConfirmationDialog(title, message, CONFIRMATION);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onAction(String action) {
                    if (EditResultSetDialog.SAVE_ID.equals(action)) {
                        if (EditResultSetDialog.this.save()) {
                            EditResultSetDialog.this.navigate(next);
                        }
                    } else if (EditResultSetDialog.REVERT_ID.equals(action)) {
                        EditResultSetDialog.this.navigate(next);
                    }
                }
            });
            dialog.show();
        } else {
            result = false;
        }
        return result;
    }

    private void navigate(boolean next) {
        if (next) {
            this.next();
        } else {
            this.previous();
        }
    }

    private void previous() {
        if (this.iter.hasPrevious()) {
            long id = this.getCurrentId();
            IMObject object = (IMObject)this.iter.previous();
            if (object.getId() == id && this.iter.hasPrevious()) {
                object = (IMObject)this.iter.previous();
            }
            this.select(object);
            this.enableButtons();
        }
    }

    private void next() {
        if (this.iter.hasNext()) {
            long id = this.getCurrentId();
            IMObject object = (IMObject)this.iter.next();
            if (object.getId() == id && this.iter.hasNext()) {
                object = (IMObject)this.iter.next();
            }
            this.select(object);
            this.enableButtons();
        }
    }

    private void select(T object) {
        T existing = object;
        if ((object = IMObjectHelper.reload(object)) == null) {
            String displayName = DescriptorHelper.getDisplayName(existing, (ArchetypeService)ServiceHelper.getArchetypeService());
            ErrorDialog.show((String)Messages.format((String)"imobject.noexist", (Object[])new Object[]{displayName}));
        } else {
            List<Selection> path = this.getSelectionPath();
            if (this.actions.canEdit(object)) {
                HelpContext help = this.getHelpContext().topic(object, "edit");
                DefaultLayoutContext context = new DefaultLayoutContext(true, this.context, help);
                context.getContext().setCurrent((IMObject)object);
                IMObjectEditor editor = context.getEditorFactory().create((IMObject)object, context);
                this.setViewer(null, null);
                this.setEditor(editor, path);
            } else {
                HelpContext help = this.getHelpContext().topic(object, "view");
                DefaultLayoutContext context = new DefaultLayoutContext(true, this.context, help);
                this.setEditor(null, null);
                IMObjectViewer viewer = new IMObjectViewer((IMObject)object, context);
                this.setViewer(viewer, path);
            }
        }
    }

    private long getCurrentId() {
        long id = -1L;
        IMObjectEditor editor = this.getEditor();
        if (editor != null) {
            id = editor.getObject().getId();
        } else if (this.viewer != null) {
            id = this.viewer.getObject().getId();
        }
        return id;
    }

    private List<Selection> getSelectionPath() {
        IMObjectEditor editor = this.getEditor();
        if (editor != null) {
            return editor.getSelectionPath();
        }
        if (this.viewer != null) {
            return this.viewer.getSelectionPath();
        }
        return null;
    }

    private void setViewer(IMObjectViewer viewer, List<Selection> path) {
        IMObjectViewer previous = this.viewer;
        if (previous != null) {
            this.removeComponent();
        }
        this.viewer = viewer;
        if (viewer != null) {
            this.setTitle(Messages.format((String)"imobject.view.title", (Object[])new Object[]{viewer.getTitle()}));
            this.setComponent(viewer.getComponent(), viewer.getFocusGroup(), viewer.getHelpContext());
            if (path != null) {
                viewer.setSelectionPath(path);
            }
        }
    }
}

