/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.lang.reflect.Constructor;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditActions;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;

public class EditDialogFactory {
    private final ArchetypeService service;
    private ArchetypeHandlers<EditDialog> dialogs;

    public EditDialogFactory(ArchetypeService service) {
        this.service = service;
    }

    public EditDialog create(IMObjectEditor editor, Context context) {
        EditDialog result = null;
        String archetype = editor.getObject().getArchetype();
        ArchetypeHandler handler = this.getDialogs().getHandler(archetype);
        if (handler != null) {
            Class type = handler.getType();
            Constructor ctor = ConstructorUtils.getMatchingAccessibleConstructor((Class)type, (Class[])new Class[]{editor.getClass(), context.getClass()});
            if (ctor != null) {
                try {
                    result = (EditDialog)((Object)ctor.newInstance(editor, context));
                }
                catch (Throwable throwable) {
                    throw new IllegalStateException("Failed to construct edit dialog " + type.getName() + " for editor " + editor.getClass().getName() + ": " + throwable.getMessage(), throwable);
                }
            } else {
                throw new IllegalStateException("No valid constructor found for edit dialog " + type.getName() + " for editor " + editor.getClass().getName());
            }
        }
        if (result == null) {
            result = new EditDialog(editor, context);
        }
        return result;
    }

    public EditDialog create(IMObjectEditor editor, EditActions actions, Context context) {
        EditDialog result = null;
        String archetype = editor.getObject().getArchetype();
        ArchetypeHandler handler = this.getDialogs().getHandler(archetype);
        if (handler != null) {
            Class type = handler.getType();
            Constructor ctor = ConstructorUtils.getMatchingAccessibleConstructor((Class)type, (Class[])new Class[]{editor.getClass(), actions.getClass(), context.getClass()});
            if (ctor != null) {
                try {
                    result = (EditDialog)((Object)ctor.newInstance(editor, actions, context));
                }
                catch (Throwable throwable) {
                    throw new IllegalStateException("Failed to construct edit dialog " + type.getName() + " for editor " + editor.getClass().getName() + ": " + throwable.getMessage(), throwable);
                }
            } else {
                throw new IllegalStateException("No valid constructor found for edit dialog " + type.getName() + " for editor " + editor.getClass().getName());
            }
        }
        if (result == null) {
            result = new EditDialog(editor, actions, context);
        }
        return result;
    }

    public boolean supportsEditActions(IMObjectEditor editor) {
        ArchetypeHandler handler = this.getDialogs().getHandler(editor.getObject().getArchetype());
        if (handler != null) {
            Constructor ctor = ConstructorUtils.getMatchingAccessibleConstructor((Class)handler.getType(), (Class[])new Class[]{editor.getClass(), EditActions.class, Context.class});
            return ctor != null;
        }
        return false;
    }

    private synchronized ArchetypeHandlers<EditDialog> getDialogs() {
        if (this.dialogs == null) {
            this.dialogs = new ArchetypeHandlers("EditDialogFactory.properties", "DefaultEditDialogFactory.properties", EditDialog.class, this.service);
        }
        return this.dialogs;
    }
}

