/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class EditActions {
    private final Set<String> buttons = new LinkedHashSet<String>();
    private final Set<String> and = new LinkedHashSet<String>();
    private boolean save = true;
    private boolean userSave = true;
    private boolean showApply;
    private boolean showOK;
    private boolean showCancel;
    private boolean showSkip;

    private EditActions() {
    }

    public EditActions setSave(boolean save) {
        this.save = save;
        return this;
    }

    public boolean save() {
        return this.save;
    }

    public EditActions setUserSave(boolean save) {
        this.userSave = save;
        return this;
    }

    public boolean userSave() {
        return this.userSave;
    }

    public EditActions setShowApply(boolean showApply) {
        this.showApply = showApply;
        return this;
    }

    public EditActions setShowOK(boolean showOK) {
        this.showOK = showOK;
        return this;
    }

    public EditActions setShowSkip(boolean showSkip) {
        this.showSkip = showSkip;
        return this;
    }

    public EditActions setShowCancel(boolean showCancel) {
        this.showCancel = showCancel;
        return this;
    }

    public EditActions add(String ... buttons) {
        this.buttons.addAll(Arrays.asList(buttons));
        this.updateFlags(this.buttons);
        return this;
    }

    public EditActions and(String ... buttons) {
        this.and.addAll(Arrays.asList(buttons));
        this.updateFlags(this.and);
        return this;
    }

    public String[] getButtons() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.buttons);
        ArrayList<String> after = new ArrayList<String>(this.and);
        this.addOrRemove(result, after, "apply", this.showApply);
        this.addOrRemove(result, after, "ok", this.showOK);
        this.addOrRemove(result, after, "skip", this.showSkip);
        this.addOrRemove(result, after, "cancel", this.showCancel);
        result.addAll(after);
        return result.toArray(new String[0]);
    }

    public static EditActions buttons(String ... buttons) {
        EditActions actions = new EditActions();
        actions.add(buttons);
        return actions;
    }

    public static EditActions ok() {
        return new EditActions().setShowOK(true);
    }

    public static EditActions cancel() {
        return new EditActions().setShowCancel(true);
    }

    public static EditActions okCancel() {
        return EditActions.ok().setShowCancel(true);
    }

    public static EditActions applyOKCancel() {
        return EditActions.okCancel().setShowApply(true);
    }

    public static EditActions applyOKCancelSkip() {
        return EditActions.applyOKCancel().setShowSkip(true);
    }

    private void addOrRemove(Set<String> buttons, List<String> after, String button, boolean show) {
        if (show) {
            if (!buttons.contains(button) && !after.contains(button)) {
                buttons.add(button);
            }
        } else {
            buttons.remove(button);
            after.remove(button);
        }
    }

    private void updateFlags(Set<String> buttons) {
        this.showApply = this.showApply || buttons.contains("apply");
        this.showOK = this.showOK || buttons.contains("ok");
        this.showCancel = this.showCancel || buttons.contains("cancel");
        this.showSkip = this.showSkip || buttons.contains("skip");
    }
}

