/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.RemoveConfirmationHandler;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractRemoveConfirmationHandler
implements RemoveConfirmationHandler {
    @Override
    public void remove(IMObject object, IMObjectCollectionEditor collection) {
        if (object.isNew()) {
            this.apply(object, collection);
        } else {
            this.confirmRemove(object, collection);
        }
    }

    protected void apply(IMObject object, IMObjectCollectionEditor collection) {
        collection.remove(object);
    }

    protected void confirmRemove(final IMObject object, final IMObjectCollectionEditor collection) {
        String displayName = this.getDisplayName(object, collection);
        String title = Messages.format((String)"imobject.collection.delete.title", (Object[])new Object[]{displayName});
        String message = Messages.format((String)"imobject.collection.delete.message", (Object[])new Object[]{displayName});
        ConfirmationDialog dialog = new ConfirmationDialog(title, message, ConfirmationDialog.YES_NO);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onYes() {
                AbstractRemoveConfirmationHandler.this.apply(object, collection);
            }

            public void onNo() {
                AbstractRemoveConfirmationHandler.this.cancelRemove(collection);
                super.onNo();
            }
        });
        dialog.show();
    }

    protected void cancelRemove(IMObjectCollectionEditor collection) {
    }

    protected String getDisplayName(IMObject object, IMObjectCollectionEditor collection) {
        return DescriptorHelper.getDisplayName((IMObject)object, (ArchetypeService)ServiceHelper.getArchetypeService());
    }
}

