/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorOperation;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.error.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIMObjectEditorOperation<T extends IMObjectEditor>
implements IMObjectEditorOperation<T> {
    private final FailureFormatter formatter;
    private static final Logger log = LoggerFactory.getLogger(AbstractIMObjectEditorOperation.class);

    public AbstractIMObjectEditorOperation(FailureFormatter formatter) {
        this.formatter = formatter;
    }

    public FailureFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void failed(T editor, Throwable exception, Runnable listener) {
        if (this.reload(editor)) {
            log.error("Reloaded editor {} for {} due to: {}", new Object[]{editor.getClass().getName(), editor.getObject().getObjectReference(), exception.getMessage(), exception});
            String title = this.formatter.getTitle((IMObjectEditor)editor);
            String message = this.formatter.getMessage((IMObjectEditor)editor, exception);
            this.reloaded(title, message, editor, listener);
        } else {
            log.error("Failed to reload editor {} for {} due to: {}", new Object[]{editor.getClass().getName(), editor.getObject().getObjectReference(), exception.getMessage()});
            this.unrecoverableFailure(editor, exception, listener);
        }
    }

    protected boolean reload(T editor) {
        return false;
    }

    protected void reloaded(String title, String message, T oldEditor, Runnable listener) {
        ErrorHandler.getInstance().error(title, message, null, listener);
    }

    protected void unrecoverableFailure(T editor, Throwable exception, Runnable listener) {
        String title = this.formatter.getTitle((IMObjectEditor)editor);
        ErrorHelper.show(title, editor.getDisplayName(), editor.getObject(), exception, listener);
    }

    public static interface FailureFormatter {
        public String getTitle(IMObjectEditor var1);

        public String getMessage(IMObjectEditor var1, Throwable var2);
    }
}

