/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectGraph;
import org.openvpms.component.business.service.singleton.SingletonService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.component.system.common.cache.MapIMObjectCache;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.component.edit.Cancellable;
import org.openvpms.web.component.edit.Deletable;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.Editors;
import org.openvpms.web.component.edit.Saveable;
import org.openvpms.web.component.i18n.WebComponentMessages;
import org.openvpms.web.component.im.audit.AuditInfo;
import org.openvpms.web.component.im.edit.DefaultEditableComponentFactory;
import org.openvpms.web.component.im.edit.EditException;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.ExpandableLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategyFactory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.lookup.LookupPropertyEditor;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.IMObjectNames;
import org.openvpms.web.component.im.view.AbstractIMObjectView;
import org.openvpms.web.component.im.view.IMObjectView;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.component.im.view.layout.EditLayoutStrategyFactory;
import org.openvpms.web.component.im.view.layout.ViewLayoutStrategyFactory;
import org.openvpms.web.component.property.AbstractModifiable;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.ModifiableListeners;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.component.property.PropertyTransformer;
import org.openvpms.web.component.property.StringPropertyTransformer;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractIMObjectEditor
extends AbstractModifiable
implements IMObjectEditor {
    private final IMObject object;
    private final IMObject parent;
    private final ArchetypeDescriptor archetype;
    private final Editors editors;
    private final Set<Editor> createdEditors = new HashSet<Editor>();
    private final PropertySet properties;
    private final Map<LookupPropertyEditor, ModifiableListener> lookups = new HashMap<LookupPropertyEditor, ModifiableListener>();
    private final LayoutContext context;
    private final ModifiableListeners listeners = new ModifiableListeners();
    private IMObjectView viewer;
    private ActionListener layoutChangeListener;
    private boolean saved = false;
    private boolean deleted = false;
    private boolean cancelled = false;
    private PropertyChangeSupport propertyChangeNotifier;
    private IArchetypeService service;
    private boolean checkSingleton = true;

    public AbstractIMObjectEditor(IMObject object, IMObject parent, LayoutContext layoutContext) {
        this.object = object;
        this.parent = parent;
        this.context = new DefaultLayoutContext(layoutContext);
        this.context.setLayoutDepth(layoutContext.getLayoutDepth());
        this.archetype = this.context.getArchetypeDescriptor(object);
        this.properties = this.createPropertySet(object, this.archetype, this.context.getVariables());
        this.editors = new Editors(this.properties, this.listeners);
        IMObjectLayoutStrategyFactory strategyFactory = this.context.getLayoutStrategyFactory();
        if (strategyFactory == null || strategyFactory instanceof ViewLayoutStrategyFactory) {
            this.context.setLayoutStrategyFactory(new EditLayoutStrategyFactory((ArchetypeService)this.getService()));
        }
        DefaultEditableComponentFactory factory = new DefaultEditableComponentFactory(this.context, this::registerEditor);
        this.context.setComponentFactory(factory);
        this.editors.addModifiableListener(this::onModified);
    }

    public AbstractIMObjectEditor(IMObjectGraph graph, LayoutContext context) {
        this((IMObject)graph.getPrimary(Entity.class), null, context);
        MapIMObjectCache cache = new MapIMObjectCache(graph, (ArchetypeService)this.getService());
        this.getLayoutContext().setCache((IMObjectCache)cache);
    }

    @Override
    public void dispose() {
        Component component;
        Component parent;
        this.editors.dispose();
        this.disposeLookups(true);
        this.listeners.removeAll();
        if (this.viewer != null && this.viewer.hasComponent() && (parent = (component = this.viewer.getComponent()).getParent()) != null) {
            parent.remove(component);
        }
    }

    @Override
    public String getTitle() {
        String title = this.object.isNew() ? Messages.format((String)"editor.new.title", (Object[])new Object[]{this.getDisplayName()}) : Messages.format((String)"editor.edit.title", (Object[])new Object[]{this.getDisplayName()});
        return title;
    }

    @Override
    public String getDisplayName() {
        return this.getArchetypeDescriptor().getDisplayName();
    }

    @Override
    public IMObject getObject() {
        return this.object;
    }

    public IMObject getParent() {
        return this.parent;
    }

    @Override
    public ArchetypeDescriptor getArchetypeDescriptor() {
        return this.archetype;
    }

    @Override
    public void save() {
        if (this.cancelled) {
            throw new IllegalStateException("Editor has been cancelled");
        }
        boolean isNew = this.object.isNew();
        if (isNew || this.isModified()) {
            this.doSave();
            this.saved = true;
            this.clearModified();
        }
    }

    @Override
    public void committed() {
        this.refreshAuditInfo();
    }

    @Override
    public boolean isSaved() {
        return this.saved;
    }

    @Override
    public void delete() {
        this.checkDeletePreconditions();
        this.prepareDelete();
        this.doDelete();
        this.deleted = true;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public boolean isModified() {
        return this.editors.isModified();
    }

    @Override
    public void clearModified() {
        this.editors.clearModified();
    }

    @Override
    public void addModifiableListener(ModifiableListener listener) {
        this.editors.addModifiableListener(listener);
    }

    @Override
    public void addModifiableListener(ModifiableListener listener, int index) {
        this.editors.addModifiableListener(listener, index);
    }

    @Override
    public void removeModifiableListener(ModifiableListener listener) {
        this.editors.removeModifiableListener(listener);
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
        this.editors.setErrorListener(listener);
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.editors.getErrorListener();
    }

    @Override
    public void setAlertListener(AlertListener listener) {
        this.editors.setAlertListener(listener);
    }

    @Override
    public AlertListener getAlertListener() {
        return this.editors.getAlertListener();
    }

    @Override
    public void cancel() {
        try {
            this.cancelled = true;
            for (Cancellable cancellable : this.editors.getCancellable()) {
                cancellable.cancel();
            }
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setSelectionPath(List<Selection> path) {
        this.getView().setSelectionPath(path);
    }

    @Override
    public List<Selection> getSelectionPath() {
        return this.getView().getSelectionPath();
    }

    @Override
    public Component getComponent() {
        return this.getView().getComponent();
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.getView().getFocusGroup();
    }

    @Override
    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        if (this.propertyChangeNotifier == null) {
            this.propertyChangeNotifier = new PropertyChangeSupport(this);
        }
        this.propertyChangeNotifier.addPropertyChangeListener(name, listener);
    }

    @Override
    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        if (this.propertyChangeNotifier != null) {
            this.propertyChangeNotifier.removePropertyChangeListener(name, listener);
        }
    }

    @Override
    public HelpContext getHelpContext() {
        return this.context.getHelpContext();
    }

    @Override
    public Property getProperty(String name) {
        return this.properties.get(name);
    }

    public CollectionProperty getCollectionProperty(String name) {
        return (CollectionProperty)this.properties.get(name);
    }

    @Override
    public IMObjectEditor newInstance() {
        return null;
    }

    protected void checkDeletePreconditions() {
        if (this.cancelled) {
            throw new IllegalStateException("Editor has been cancelled");
        }
    }

    protected void prepareDelete() {
    }

    protected PropertySet createPropertySet(IMObject object, ArchetypeDescriptor archetype, Variables variables) {
        return new PropertySetBuilder(object, archetype, variables).build();
    }

    @Override
    protected void resetValid(boolean descendants) {
        super.resetValid(descendants);
        if (descendants) {
            this.editors.resetValid();
        }
    }

    @Override
    protected boolean doValidation(Validator validator) {
        List<ValidatorError> errors;
        boolean result;
        boolean bl = result = validator.validate(this.editors) && this.validateSingleton(validator);
        if (result && (errors = ValidationHelper.validate(this.object, (ArchetypeService)this.getService())) != null) {
            validator.add((Modifiable)this, errors);
            result = false;
        }
        return result;
    }

    protected void doSave() {
        if (this.activeSingletonExists()) {
            throw new EditException(WebComponentMessages.activeSingletonExists(this.archetype.getDisplayName()));
        }
        this.saveChildren();
        this.saveObject();
    }

    protected void saveObject() {
        IMObject object = this.getObject();
        this.getService().save(object);
    }

    protected void saveChildren() {
        for (Saveable saveable : this.editors.getModifiedSaveable()) {
            saveable.save();
        }
    }

    protected void doDelete() {
        this.deleteChildren();
        this.deleteObject();
    }

    protected void deleteObject() {
        IMObject object = this.getObject();
        if (!object.isNew()) {
            this.getService().remove(object);
        }
    }

    protected void deleteChildren() {
        for (Deletable deletable : this.editors.getDeletable()) {
            deletable.delete();
        }
    }

    protected PropertySet getProperties() {
        return this.properties;
    }

    protected void addEditor(Editor editor) {
        if (editor instanceof LookupPropertyEditor) {
            LookupPropertyEditor lookup = (LookupPropertyEditor)editor;
            ModifiableListener listener = modifiable -> this.refreshLookups(lookup);
            lookup.getProperty().addModifiableListener(listener);
            this.lookups.put((LookupPropertyEditor)editor, listener);
        }
        this.editors.add(editor);
    }

    protected Editors getEditors() {
        return this.editors;
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.propertyChangeNotifier != null) {
            this.propertyChangeNotifier.firePropertyChange(name, oldValue, newValue);
        }
    }

    protected IMObjectView getView() {
        if (this.viewer == null) {
            this.viewer = this.createView(this.object);
        }
        return this.viewer;
    }

    protected IMObjectView createView(IMObject object) {
        IMObjectLayoutStrategy layout = this.createLayoutStrategy();
        AbstractIMObjectView view = new AbstractIMObjectView(object, this.properties, this.parent, layout){

            @Override
            protected Component createComponent() {
                AbstractIMObjectEditor.this.disposeLookups(false);
                return super.createComponent();
            }

            @Override
            protected LayoutContext getLayoutContext() {
                return AbstractIMObjectEditor.this.context;
            }
        };
        view.setLayoutListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent e) {
                AbstractIMObjectEditor.this.onLayoutCompleted();
            }
        });
        if (layout instanceof ExpandableLayoutStrategy) {
            view.getComponent();
            ExpandableLayoutStrategy exp = (ExpandableLayoutStrategy)layout;
            Button button = exp.getButton();
            if (button != null) {
                button.addActionListener((nextapp.echo2.app.event.ActionListener)this.getLayoutChangeListener());
            }
        }
        return view;
    }

    protected LayoutContext getLayoutContext() {
        return this.context;
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        IMObjectLayoutStrategyFactory layoutStrategy = this.context.getLayoutStrategyFactory();
        return layoutStrategy.create(this.getObject(), this.getParent());
    }

    protected void onLayout() {
        this.disposeOnChangeLayout();
        if (this.getView().getLayout() instanceof ExpandableLayoutStrategy) {
            ExpandableLayoutStrategy expandable;
            expandable.setShowOptional(!(expandable = (ExpandableLayoutStrategy)this.getView().getLayout()).isShowOptional());
            this.getView().setLayout(expandable);
            Button button = expandable.getButton();
            if (button != null) {
                button.addActionListener((nextapp.echo2.app.event.ActionListener)this.getLayoutChangeListener());
            }
        } else {
            ExpandableLayoutStrategy exp;
            Button button;
            IMObjectLayoutStrategy layout = this.createLayoutStrategy();
            this.getView().setLayout(layout);
            if (layout instanceof ExpandableLayoutStrategy && (button = (exp = (ExpandableLayoutStrategy)layout).getButton()) != null) {
                button.addActionListener((nextapp.echo2.app.event.ActionListener)this.getLayoutChangeListener());
            }
        }
        this.firePropertyChange("component", null, this);
    }

    protected void disposeOnChangeLayout() {
        Set<Editor> set = this.editors.getEditors();
        for (Editor editor : set.toArray(new Editor[0])) {
            if (!this.disposeOnChangeLayout(editor)) continue;
            this.editors.remove(editor);
            this.createdEditors.remove(editor);
            editor.dispose();
        }
    }

    protected boolean disposeOnChangeLayout(Editor editor) {
        return this.createdEditors.contains(editor);
    }

    protected void onLayoutCompleted() {
    }

    protected void onModified(Modifiable modifiable) {
        this.resetValid(false);
    }

    protected void refreshLookups(LookupPropertyEditor source) {
        for (LookupPropertyEditor editor : this.lookups.keySet()) {
            if (source == editor) continue;
            editor.refresh();
        }
        FocusHelper.setFocus((Component)source.getComponent());
    }

    protected ActionListener getLayoutChangeListener() {
        if (this.layoutChangeListener == null) {
            this.layoutChangeListener = new ActionListener(){

                public void onAction(ActionEvent event) {
                    AbstractIMObjectEditor.this.onLayout();
                }
            };
        }
        return this.layoutChangeListener;
    }

    protected NodeDescriptor getDescriptor(String name) {
        return this.getArchetypeDescriptor().getNodeDescriptor(name);
    }

    protected Editor getEditor(String name) {
        return this.getEditor(name, true);
    }

    protected Editor getEditor(String name, boolean create) {
        if (create) {
            this.getComponent();
        }
        return this.editors.getEditor(name);
    }

    protected IMObject getTarget(String name) {
        IMObject result = null;
        CollectionProperty property = this.getCollectionProperty(name);
        List<?> values = property.getValues();
        if (!values.isEmpty()) {
            Relationship relationship = (Relationship)values.get(0);
            result = this.getObject(relationship.getTarget());
        }
        return result;
    }

    protected ModifiableListeners getListeners() {
        return this.listeners;
    }

    protected IMObject getObject(Reference reference) {
        return this.getLayoutContext().getCache().get(reference);
    }

    protected boolean setFocus(Property property) {
        boolean result = false;
        Editor editor = this.editors.getEditor(property.getName());
        if (editor != null && editor.getFocusGroup() != null) {
            editor.getFocusGroup().setFocus();
            result = true;
        }
        return result;
    }

    protected <T extends IMObject> T reload(T object) {
        return IMObjectHelper.reload(object, true);
    }

    protected IMObjectBean getBean(IMObject object) {
        return this.getService().getBean(object);
    }

    protected LayoutContext newLayoutContext() {
        DefaultLayoutContext result = new DefaultLayoutContext(this.context);
        result.setLayoutDepth(this.context.getLayoutDepth());
        result.setCache(null);
        return result;
    }

    protected String getName(Reference reference) {
        return reference != null ? this.getLayoutContext().getNames().getName(reference) : null;
    }

    protected String getDisplayName(IMObject object) {
        return this.getDisplayName(object.getArchetype());
    }

    protected String getDisplayName(String archetype) {
        String displayName = DescriptorHelper.getDisplayName((String)archetype, (ArchetypeService)this.getService());
        return displayName != null ? displayName : archetype;
    }

    protected String getDisplayName(String archetype, String node) {
        String displayName = DescriptorHelper.getDisplayName((String)archetype, (String)node, (ArchetypeService)this.getService());
        return displayName != null ? displayName : node;
    }

    protected <T extends IMObject> T create(String archetype, Class<T> type) {
        return (T)this.getService().create(archetype, type);
    }

    protected void disableMacroExpansion(String name) {
        PropertyTransformer transformer;
        Property property = this.getProperty(name);
        if (property != null && (transformer = property.getTransformer()) instanceof StringPropertyTransformer) {
            ((StringPropertyTransformer)transformer).setExpandMacros(false);
        }
    }

    protected boolean validateSingleton(Validator validator) {
        boolean result = true;
        if (this.checkSingleton) {
            if (this.activeSingletonExists()) {
                validator.add((Modifiable)this, Messages.format((String)"imobject.singletonexists", (Object[])new Object[]{this.archetype.getDisplayName()}));
                result = false;
            } else {
                this.checkSingleton = false;
            }
        }
        return result;
    }

    protected boolean activeSingletonExists() {
        boolean result = false;
        if (this.archetype.isSingleton() && this.object.isActive()) {
            SingletonService service = ServiceHelper.getBean(SingletonService.class);
            result = service.exists(this.object.getArchetype(), this.getObject().getObjectReference());
        }
        return result;
    }

    protected boolean reportRequired(String name, Validator validator) {
        Property property = this.getProperty(name);
        if (property != null) {
            this.reportRequired(property, validator);
        }
        return false;
    }

    protected boolean reportRequired(Property property, Validator validator) {
        String message = Messages.format((String)"property.error.required", (Object[])new Object[]{property.getDisplayName()});
        validator.add((Modifiable)property, new ValidatorError(property, message));
        return false;
    }

    protected IArchetypeService getService() {
        if (this.service == null) {
            this.service = ServiceHelper.getArchetypeService();
        }
        return this.service;
    }

    private void refreshAuditInfo() {
        if (this.viewer != null && this.viewer.hasComponent()) {
            Component component = this.viewer.getComponent();
            this.refreshAuditInfo(component, this.context.getNames());
        }
    }

    private void refreshAuditInfo(Component component, IMObjectNames names) {
        if (component instanceof AuditInfo) {
            ((AuditInfo)component).refresh(names);
        }
        for (Component child : component.getComponents()) {
            this.refreshAuditInfo(child, names);
        }
    }

    private void registerEditor(Editor editor) {
        this.addEditor(editor);
        this.createdEditors.add(editor);
    }

    private void disposeLookups(boolean all) {
        ArrayList<Map.Entry<LookupPropertyEditor, ModifiableListener>> entries = new ArrayList<Map.Entry<LookupPropertyEditor, ModifiableListener>>(this.lookups.entrySet());
        for (Map.Entry entry : entries) {
            LookupPropertyEditor editor = (LookupPropertyEditor)entry.getKey();
            boolean dispose = all || this.createdEditors.contains(editor);
            if (!dispose) continue;
            editor.removeModifiableListener((ModifiableListener)entry.getValue());
            this.lookups.remove(editor);
        }
    }
}

