/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.List;
import java.util.function.Consumer;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyComponentEditor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.doc.DocumentEditor;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditorFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditorFactory;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.lookup.LookupPropertyEditor;
import org.openvpms.web.component.im.lookup.LookupPropertyEditorFactory;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.view.AbstractIMObjectComponentFactory;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.Hint;
import org.openvpms.web.component.im.view.ReadOnlyComponentFactory;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;

public class AbstractEditableComponentFactory
extends AbstractIMObjectComponentFactory {
    private final Consumer<Editor> editorListener;
    private final IMObjectEditorFactory factory;
    private ReadOnlyComponentFactory readOnly;

    public AbstractEditableComponentFactory(LayoutContext context, String style) {
        this(context, style, null);
    }

    public AbstractEditableComponentFactory(LayoutContext context, String style, Consumer<Editor> editorListener) {
        super(context, style);
        this.factory = context.getEditorFactory();
        this.editorListener = editorListener;
    }

    @Override
    public String getReadOnlyStyle() {
        return this.getReadOnlyFactory().getStyle();
    }

    @Override
    public Component create(Property property) {
        return this.create(property, (Hint)null);
    }

    @Override
    public Component create(Property property, Hint hint) {
        Component result = property.isReadOnly() || property.isDerived() ? this.getReadOnlyFactory().create(property, hint) : super.create(property, hint);
        return result;
    }

    @Override
    public ComponentState create(Property property, IMObject context) {
        return this.create(property, context, null);
    }

    @Override
    public ComponentState create(Property property, IMObject context, Hint hint) {
        ComponentState result;
        if (property.isReadOnly() || property.isDerived()) {
            result = this.getReadOnlyFactory().create(property, context, hint);
        } else {
            Editor editor = null;
            if (property.isLookup()) {
                editor = this.createLookupEditor(property, context);
            } else if (property.isBoolean()) {
                editor = this.createBooleanEditor(property);
            } else if (property.isString()) {
                editor = property.isPassword() ? this.createPasswordEditor(property) : this.createStringEditor(property, hint);
            } else if (property.isNumeric()) {
                editor = this.createNumericEditor(property);
            } else if (property.isDate()) {
                editor = this.createDateEditor(property);
            } else if (property.isCollection()) {
                editor = this.createCollectionEditor((CollectionProperty)property, context);
            } else if (property.isObjectReference()) {
                editor = this.createObjectReferenceEditor(property, context);
            }
            if (editor != null) {
                result = new ComponentState(editor.getComponent(), property, editor.getFocusGroup());
            } else {
                Label label = LabelFactory.create();
                label.setText("No editor for type " + property.getType());
                result = new ComponentState((Component)label);
            }
        }
        return result;
    }

    @Override
    public ComponentState create(IMObject object, IMObject context) {
        this.getLayoutContext().setRendered(object);
        IMObjectEditor editor = this.getObjectEditor(object, context, this.getLayoutContext());
        return new ComponentState(editor.getComponent(), editor.getFocusGroup());
    }

    protected IMObjectEditor getObjectEditor(IMObject object, IMObject parent, LayoutContext context) {
        IMObjectEditor editor = this.factory.create(object, parent, context);
        this.created(editor);
        return editor;
    }

    protected Editor createNumericEditor(Property property) {
        Component component = this.createNumeric(property);
        return this.createPropertyEditor(property, component);
    }

    protected Editor createDateEditor(Property property) {
        Component date = this.createDate(property);
        return this.createPropertyEditor(property, date);
    }

    protected LookupPropertyEditor createLookupEditor(Property property, IMObject context) {
        LookupPropertyEditor editor = LookupPropertyEditorFactory.create(property, context, this.getLayoutContext());
        this.created(editor);
        return editor;
    }

    protected Editor createBooleanEditor(Property property) {
        Component component = this.createBoolean(property);
        return this.createPropertyEditor(property, component);
    }

    protected Editor createStringEditor(Property property, Hint hint) {
        Component component = this.createString(property, hint);
        return this.createPropertyEditor(property, component);
    }

    protected Editor createPasswordEditor(Property property) {
        Component component = this.createPassword(property);
        return this.createPropertyEditor(property, component);
    }

    protected Editor createCollectionEditor(CollectionProperty property, IMObject object) {
        IMObject value;
        List<?> values;
        String[] range;
        if (property.isParentChild() && property.getMinCardinality() == 1 && property.getMaxCardinality() == 1 && (range = property.getArchetypeRange()).length == 1 && (values = property.getValues()).isEmpty() && (value = IMObjectCreator.create(range[0])) != null) {
            property.add(value);
        }
        LayoutContext context = this.getLayoutContext();
        HelpContext help = context.getHelpContext().subtopic(property.getName());
        DefaultLayoutContext subContext = new DefaultLayoutContext(context, help);
        IMObjectCollectionEditor editor = IMObjectCollectionEditorFactory.create(property, object, subContext);
        this.created(editor);
        return editor;
    }

    protected Editor createObjectReferenceEditor(Property property, IMObject object) {
        String[] range = property.getArchetypeRange();
        LayoutContext context = this.getLayoutContext();
        PropertyEditor editor = TypeHelper.matches((String[])range, (String)"document.*") ? new DocumentEditor(property, context) : IMObjectReferenceEditorFactory.create(property, object, context);
        this.created(editor);
        return editor;
    }

    protected PropertyEditor createPropertyEditor(Property property, Component component) {
        PropertyComponentEditor editor = new PropertyComponentEditor(property, component);
        this.created(editor);
        return editor;
    }

    private void created(Editor editor) {
        if (this.editorListener != null) {
            this.editorListener.accept(editor);
        }
    }

    private ReadOnlyComponentFactory getReadOnlyFactory() {
        if (this.readOnly == null) {
            this.readOnly = new ReadOnlyComponentFactory(this.getLayoutContext(), "edit");
        }
        return this.readOnly;
    }
}

