/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.business.service.archetype.helper.IMObjectVariables;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNameFormatter {
    private final ArchetypeService service;
    private final LookupService lookups;
    private final PatientRules rules;
    private static final String ILLEGAL_CHARACTERS = "[\\\\/:*?<>|]";
    private static final Logger log = LoggerFactory.getLogger(FileNameFormatter.class);

    public FileNameFormatter(ArchetypeService service, LookupService lookups, PatientRules rules) {
        this.service = service;
        this.lookups = lookups;
        this.rules = rules;
    }

    public String format(String name, IMObject object, DocumentTemplate template) {
        String expression = template.getFileNameExpression();
        return this.format(name, object, expression);
    }

    public String format(String name, IMObject object, Lookup format) {
        IMObjectBean bean = this.service.getBean((IMObject)format);
        String expression = bean.getString("expression");
        return this.format(name, object, expression);
    }

    protected String format(String name, IMObject object, String expression) {
        String result;
        String file = FilenameUtils.getBaseName((String)name);
        if (!StringUtils.isEmpty((CharSequence)expression)) {
            JXPathContext context = JXPathHelper.newContext((Object)(object != null ? object : new Object()));
            FileNameVariables variables = new FileNameVariables(this.service, this.lookups);
            context.setVariables((Variables)variables);
            Party patient = null;
            Party customer = null;
            Party supplier = null;
            if (object instanceof Act) {
                Act act = (Act)object;
                IMObjectBean bean = this.service.getBean((IMObject)act);
                if (bean.hasNode("patient")) {
                    patient = (Party)bean.getTarget("patient", Party.class);
                }
                if (bean.hasNode("customer")) {
                    customer = (Party)bean.getTarget("customer", Party.class);
                } else if (patient != null) {
                    customer = this.rules.getOwner(patient, act.getActivityStartTime(), false);
                }
                if (bean.hasNode("supplier")) {
                    supplier = (Party)bean.getTarget("supplier", Party.class);
                }
            }
            variables.declareVariable("customer", customer);
            variables.declareVariable("patient", patient);
            variables.declareVariable("supplier", supplier);
            variables.declareVariable("file", file);
            try {
                Object value = context.getValue(expression);
                result = value != null ? this.clean(value.toString()) : file;
            }
            catch (Throwable exception) {
                log.error("Failed to evaluate expression: " + expression, exception);
                result = file;
            }
        } else {
            result = file;
        }
        return result;
    }

    private String clean(String name) {
        return name.replaceAll(ILLEGAL_CHARACTERS, "_");
    }

    private static class FileNameVariables
    implements Variables {
        private final IMObjectVariables variables;

        public FileNameVariables(ArchetypeService service, LookupService lookups) {
            this.variables = new IMObjectVariables(service, lookups);
        }

        public boolean isDeclaredVariable(String varName) {
            return this.variables.exists(varName);
        }

        public Object getVariable(String varName) {
            return this.variables.get(varName);
        }

        public void declareVariable(String varName, Object value) {
            this.variables.add(varName, value);
        }

        public void undeclareVariable(String varName) {
        }
    }
}

