/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.report.DocumentConverter;
import org.openvpms.web.component.im.doc.DocumentJobManager;
import org.openvpms.web.component.im.doc.DownloaderListener;
import org.openvpms.web.component.job.Job;
import org.openvpms.web.component.job.JobBuilder;
import org.openvpms.web.echo.servlet.DownloadServlet;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public abstract class Downloader {
    protected static final String DEFAULT_BUTTON_STYLE = "download.default";
    private final ArchetypeService service = ServiceHelper.getArchetypeService();
    private final DocumentConverter converter = ServiceHelper.getBean(DocumentConverter.class);
    private DownloaderListener listener;
    private int nameLength = -1;

    public void setListener(DownloaderListener listener) {
        this.listener = listener;
    }

    public abstract Component getComponent();

    public void download() {
        this.download(null);
    }

    public void download(String mimeType) {
        Job<Document> job = JobBuilder.newJob("Download", this.getUser()).get(() -> this.getDocument(mimeType)).completed(document -> {
            if (document == null) {
                throw new DocumentException(DocumentException.ErrorCode.NotFound, new Object[0]);
            }
            DownloadServlet.startDownload((Document)document);
        }).build();
        DocumentJobManager manager = ServiceHelper.getBean(DocumentJobManager.class);
        manager.runInteractive(job, Messages.get((String)"document.download.title"), Messages.get((String)"document.download.cancel"));
    }

    public void setNameLength(int length) {
        if (length > 5) {
            this.nameLength = length;
        }
    }

    protected abstract Document getDocument(String var1);

    protected void selected(String mimeType) {
        if (this.listener != null) {
            this.listener.download(this, mimeType);
        } else {
            this.download(mimeType);
        }
    }

    protected Document getDocumentByRef(Reference reference, String mimeType) {
        Document result = (Document)this.service.get(reference, Document.class);
        if (result != null && mimeType != null && !mimeType.equals(result.getMimeType())) {
            result = this.convert(result, mimeType);
        }
        return result;
    }

    protected Document convert(Document document, String mimeType) {
        return this.converter.convert(document, mimeType);
    }

    protected abstract User getUser();

    protected void setButtonNameAndStyle(Button button, String name, String description) {
        String styleName = this.getStyleName(name);
        button.setStyleName(styleName);
        this.setButtonName(button, name, description);
    }

    protected void setButtonName(Button button, String name, String description) {
        String text = name;
        String tooltip = null;
        if (description != null) {
            text = Messages.format((String)"imobject.summary", (Object[])new Object[]{name, description});
        }
        if (this.nameLength > 0 && text.length() > this.nameLength) {
            tooltip = text;
            text = StringUtils.abbreviateMiddle((String)text, (String)"...", (int)this.nameLength);
        }
        button.setText(text);
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
    }

    protected String getStyleName(String name) {
        String styleName;
        if (name != null) {
            String ext = FilenameUtils.getExtension((String)name).toLowerCase();
            styleName = "download." + ext;
            ApplicationInstance active = ApplicationInstance.getActive();
            if (active.getStyle(Button.class, styleName) == null) {
                styleName = DEFAULT_BUTTON_STYLE;
            }
        } else {
            styleName = DEFAULT_BUTTON_STYLE;
        }
        return styleName;
    }

    protected ArchetypeService getService() {
        return this.service;
    }
}

