/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.io.InputStream;
import nextapp.echo2.app.filetransfer.UploadEvent;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.model.document.Document;
import org.openvpms.web.component.im.doc.AbstractUploadListener;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public abstract class DocumentUploadListener
extends AbstractUploadListener {
    private final DocumentHandler handler;

    public DocumentUploadListener() {
        this(null);
    }

    public DocumentUploadListener(DocumentHandler handler) {
        this.handler = handler;
    }

    public void fileUpload(UploadEvent event) {
        String fileName = event.getFileName();
        String contentType = event.getContentType();
        try {
            InputStream stream = event.getInputStream();
            int size = event.getSize();
            if (this.checkSupported(fileName, contentType)) {
                Document doc = this.getDocument(stream, fileName, contentType, size);
                this.upload(doc);
            }
        }
        catch (Throwable exception) {
            ErrorHelper.show(exception);
        }
    }

    protected boolean checkSupported(String fileName, String contentType) {
        boolean supported;
        if (this.handler != null) {
            supported = this.handler.canHandle(fileName, contentType);
        } else {
            DocumentHandlers handlers = ServiceHelper.getDocumentHandlers();
            boolean bl = supported = handlers.find(fileName, contentType) != null;
        }
        if (!supported) {
            ErrorHelper.show(Messages.format((String)"document.upload.unsupported", (Object[])new Object[]{fileName, contentType}));
        }
        return supported;
    }

    protected Document getDocument(InputStream stream, String fileName, String contentType, int size) {
        DocumentHandler h;
        if (this.handler != null) {
            if (!this.handler.canHandle(fileName, contentType)) {
                throw new DocumentException(DocumentException.ErrorCode.UnsupportedDoc, new Object[]{fileName, contentType});
            }
            h = this.handler;
        } else {
            h = this.getDocumentHandler(fileName, contentType);
        }
        return h.create(fileName, stream, contentType, size);
    }

    protected DocumentHandler getDocumentHandler(String fileName, String contentType) {
        DocumentHandlers handlers = ServiceHelper.getDocumentHandlers();
        return handlers.get(fileName, contentType);
    }

    protected abstract void upload(Document var1);
}

