/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.web.component.edit.AbstractPropertyEditor;
import org.openvpms.web.component.edit.Cancellable;
import org.openvpms.web.component.edit.Deletable;
import org.openvpms.web.component.edit.Saveable;
import org.openvpms.web.component.im.doc.DocReferenceMgr;
import org.openvpms.web.component.im.doc.DocumentUploadListener;
import org.openvpms.web.component.im.doc.UploadDialog;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.select.BasicSelector;
import org.openvpms.web.component.im.select.Selector;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public class DocumentEditor
extends AbstractPropertyEditor
implements Saveable,
Cancellable,
Deletable {
    private final HelpContext help;
    private final IArchetypeService service;
    private final BasicSelector<Document> selector;
    private final DocReferenceMgr refMgr;
    private boolean saved = false;
    private String name;
    private String mimeType;

    public DocumentEditor(Property property, LayoutContext context) {
        super(property);
        this.help = context.getHelpContext();
        this.service = ServiceHelper.getArchetypeService();
        this.selector = new BasicSelector("button.upload", context.getLayoutDepth() <= 1);
        this.selector.setFormat(Selector.Format.NAME);
        this.selector.getSelect().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                DocumentEditor.this.onUpload();
            }
        });
        Reference original = property.getReference();
        if (original != null) {
            this.init(original);
        }
        this.refMgr = new DocReferenceMgr(original, (ArchetypeService)ServiceHelper.getArchetypeService());
    }

    @Override
    public Component getComponent() {
        return this.selector.getComponent();
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.selector.getFocusGroup();
    }

    public void setDocument(Document document) {
        this.setDocument(document, false);
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Reference getReference() {
        return this.getProperty().getReference();
    }

    @Override
    public void save() {
        this.refMgr.commit();
        this.saved = true;
    }

    @Override
    public boolean isSaved() {
        return this.saved;
    }

    @Override
    public void cancel() {
        try {
            this.refMgr.rollback();
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
    }

    @Override
    public void delete() {
        this.refMgr.delete();
    }

    protected BasicSelector<Document> getSelector() {
        return this.selector;
    }

    protected void setDocument(Document document, boolean keepOld) {
        Reference old = this.getReference();
        if (old != null && keepOld) {
            this.refMgr.remove(old);
        }
        if (document != null) {
            this.service.save((IMObject)document);
            this.name = document.getName();
            this.mimeType = document.getMimeType();
            Reference ref = document.getObjectReference();
            this.getProperty().setValue(ref);
            this.refMgr.add(ref);
        } else {
            this.name = null;
            this.mimeType = null;
            this.getProperty().setValue(null);
        }
        this.selector.setObject(document);
    }

    private void onUpload() {
        DocumentUploadListener listener = new DocumentUploadListener(){

            @Override
            protected void upload(Document document) {
                DocumentEditor.this.setDocument(document);
            }
        };
        UploadDialog dialog = new UploadDialog(listener, this.help.subtopic("upload"));
        dialog.show();
    }

    private void init(Reference reference) {
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)new ObjectRefConstraint("doc", reference));
        query.add((IConstraint)new NodeSelectConstraint("doc.name"));
        query.add((IConstraint)new NodeSelectConstraint("doc.mimeType"));
        ObjectSetQueryIterator iter = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        if (iter.hasNext()) {
            ObjectSet set = (ObjectSet)iter.next();
            this.name = set.getString("doc.name");
            this.mimeType = set.getString("doc.mimeType");
            this.selector.setObject(this.name, null, true);
        }
    }
}

