/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.util.Comparator;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.doc.DocumentViewer;
import org.openvpms.web.component.im.doc.DocumentViewerFactory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.act.ActAmountTableModel;
import org.openvpms.web.component.im.util.IMObjectNames;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.system.ServiceHelper;

public class DocumentActTableModel
extends ActAmountTableModel<DocumentAct> {
    private final LayoutContext context;
    private final DocumentViewerFactory factory;
    private int docIndex;
    private int versionsIndex = -1;

    public DocumentActTableModel(LayoutContext context) {
        this(true, true, true, context);
    }

    public DocumentActTableModel(boolean showArchetype, boolean showStatus, boolean showVersions, LayoutContext context) {
        super(showArchetype, showStatus, false);
        this.context = context;
        this.factory = ServiceHelper.getBean(DocumentViewerFactory.class);
        if (showVersions) {
            DefaultTableColumnModel model = (DefaultTableColumnModel)this.getColumnModel();
            this.versionsIndex = this.getNextModelIndex((TableColumnModel)model);
            model.addColumn(DocumentActTableModel.createTableColumn(this.versionsIndex, "document.acttablemodel.versions"));
        }
    }

    @Override
    protected Object getValue(DocumentAct act, TableColumn column, int row) {
        int index = column.getModelIndex();
        Object result = index == this.docIndex ? this.createDocumentViewer(act) : (index == this.versionsIndex ? this.getVersions(act) : super.getValue(act, column, row));
        return result;
    }

    @Override
    protected String getDescription(DocumentAct object) {
        String description = super.getDescription(object);
        if (description == null && object.isA("act.patientInvestigation")) {
            description = this.getInvestigationProductName(object);
        }
        return description;
    }

    protected Component createDocumentViewer(DocumentAct act) {
        DocumentViewer viewer = this.factory.create(act, true, this.context);
        viewer.setShowNoDocument(false);
        return viewer.getComponent();
    }

    private String getInvestigationProductName(DocumentAct object) {
        String result = null;
        IMObjectBean bean = this.getBean((IMObject)object);
        List products = bean.getTargetRefs("products");
        int size = products.size();
        if (size > 0) {
            if (size > 1) {
                products.sort(Comparator.comparingLong(Reference::getId));
            }
            IMObjectNames names = this.getContext().getNames();
            result = names.getName((Reference)products.get(0));
        }
        return result;
    }

    @Override
    protected TableColumnModel createColumnModel(boolean showArchetype, boolean showStatus, boolean showAmount, boolean showDescription) {
        DefaultTableColumnModel model = (DefaultTableColumnModel)super.createColumnModel(showArchetype, showStatus, showAmount, showDescription);
        this.docIndex = this.getNextModelIndex((TableColumnModel)model);
        model.addColumn(DocumentActTableModel.createTableColumn(this.docIndex, "document.acttablemodel.doc"));
        if (showAmount) {
            model.moveColumn(model.getColumnCount() - 1, this.getColumnOffset((TableColumnModel)model, 8));
        }
        return model;
    }

    protected LayoutContext getContext() {
        return this.context;
    }

    private Label getVersions(DocumentAct act) {
        int versions;
        Label result = null;
        IMObjectBean bean = this.getBean((IMObject)act);
        if (bean.hasNode("versions") && (versions = bean.getValues("versions").size()) > 0) {
            result = TableHelper.rightAlign((String)Integer.toString(versions));
        }
        return result;
    }
}

